/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.preset;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.end.WoverEndConfig;
import org.betterx.wover.generator.api.biomesource.nether.WoverNetherConfig;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.betterx.wover.generator.impl.biomesource.nether.WoverNetherBiomeSource;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGenerator;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.preset.api.context.WorldPresetBootstrapContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PresetRegistryImpl {
    public static final ResourceKey<WorldPreset> WOVER_WORLD = WorldPresetManager.createKey((ResourceLocation)LibWoverWorldGenerator.C.id("normal"));
    public static final ResourceKey<WorldPreset> WOVER_WORLD_LARGE = WorldPresetManager.createKey((ResourceLocation)LibWoverWorldGenerator.C.id("large"));
    public static final ResourceKey<WorldPreset> WOVER_WORLD_AMPLIFIED = WorldPresetManager.createKey((ResourceLocation)LibWoverWorldGenerator.C.id("amplified"));
    public static final ResourceKey<WorldPreset> BCL_WORLD_17 = WorldPresetManager.createKey((ResourceLocation)LegacyHelper.BCLIB_CORE.id("legacy_17"));

    @NotNull
    public static LevelStem makeWoverNetherStem(WorldPresetBootstrapContext.StemContext context, WoverNetherConfig config) {
        WoverNetherBiomeSource netherSource = new WoverNetherBiomeSource(config);
        return new LevelStem(context.dimension, (ChunkGenerator)new WoverChunkGenerator(netherSource, (Holder<NoiseGeneratorSettings>)context.generatorSettings));
    }

    public static LevelStem makeWoverEndStem(WorldPresetBootstrapContext.StemContext context, WoverEndConfig config) {
        WoverEndBiomeSource endSource = new WoverEndBiomeSource(config);
        return new LevelStem(context.dimension, (ChunkGenerator)new WoverChunkGenerator(endSource, (Holder<NoiseGeneratorSettings>)context.generatorSettings));
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
    }
}

