/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import org.betterx.wover.biome.impl.modification.ChunkGeneratorHelper;
import org.betterx.wover.biome.mixin.ChunkGeneratorAccessor;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.wover.common.generator.api.biomesource.MergeableBiomeSource;
import org.betterx.wover.common.generator.api.biomesource.NoiseGeneratorSettingsProvider;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.common.generator.api.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.wover.common.generator.api.chunkgenerator.RebuildableFeaturesPerStep;
import org.betterx.wover.common.generator.api.chunkgenerator.RestorableBiomeSource;
import org.betterx.wover.common.surface.api.InjectableSurfaceRules;
import org.betterx.wover.core.api.IntegrationCore;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.ChunkGeneratorManagerImpl;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGeneratorImpl;
import org.betterx.wover.surface.impl.SurfaceRuleUtil;
import org.jetbrains.annotations.NotNull;

public class WoverChunkGenerator
extends NoiseBasedChunkGenerator
implements RestorableBiomeSource<WoverChunkGenerator>,
InjectableSurfaceRules<WoverChunkGenerator>,
EnforceableChunkGenerator<WoverChunkGenerator>,
RebuildableFeaturesPerStep<WoverChunkGenerator> {
    public static final ResourceLocation ID = LibWoverWorldGenerator.C.id("betterx");
    protected static final NoiseSettings NETHER_NOISE_SETTINGS_AMPLIFIED = NoiseSettings.create((int)0, (int)256, (int)1, (int)4);
    public static final ResourceKey<NoiseGeneratorSettings> AMPLIFIED_NETHER = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)LibWoverWorldGenerator.C.id("amplified_nether"));
    public static final MapCodec<WoverChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(builderInstance -> {
        RecordCodecBuilder biomeSourceCodec = BiomeSource.CODEC.fieldOf("biome_source").forGetter(generator -> generator.biomeSource);
        RecordCodecBuilder settingsCodec = NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.generatorSettings());
        return builderInstance.group((App)biomeSourceCodec, (App)settingsCodec).apply((Applicative)builderInstance, builderInstance.stable(WoverChunkGenerator::new));
    });
    public final BiomeSource initialBiomeSource;

    public WoverChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> holder) {
        super(biomeSource, holder);
        this.initialBiomeSource = biomeSource;
        if (biomeSource instanceof BiomeSourceWithNoiseRelatedSettings) {
            BiomeSourceWithNoiseRelatedSettings bcl = (BiomeSourceWithNoiseRelatedSettings)biomeSource;
            if (holder.isBound()) {
                bcl.onLoadGeneratorSettings((NoiseGeneratorSettings)holder.value());
            }
        }
        if (IntegrationCore.RUNS_TERRABLENDER) {
            LibWoverWorldGenerator.C.log.info("Make sure features are loaded from terrablender:" + biomeSource.getClass().getName());
            ChunkGeneratorHelper.rebuildFeaturesPerStep((ChunkGenerator)this, (BiomeSource)biomeSource);
        }
        LibWoverWorldGenerator.C.log.info("Created WoverChunkGenerator with " + biomeSource.getClass().getName());
    }

    @NotNull
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void wover_rebuildFeaturesPerStep() {
        ChunkGeneratorHelper.rebuildFeaturesPerStep((ChunkGenerator)this, (BiomeSource)this.getBiomeSource());
    }

    public void restoreInitialBiomeSource(ResourceKey<LevelStem> dimensionKey) {
        WoverChunkGenerator woverChunkGenerator;
        if (this.initialBiomeSource != this.getBiomeSource() && (woverChunkGenerator = this) instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor acc = (ChunkGeneratorAccessor)woverChunkGenerator;
            BiomeSource biomeSource = this.initialBiomeSource;
            if (biomeSource instanceof MergeableBiomeSource) {
                MergeableBiomeSource bs = (MergeableBiomeSource)biomeSource;
                acc.wover_setBiomeSource(bs.mergeWithBiomeSource(this.getBiomeSource()));
            } else {
                biomeSource = this.initialBiomeSource;
                if (biomeSource instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource bs = (ReloadableBiomeSource)biomeSource;
                    bs.reloadBiomes();
                }
            }
            ChunkGeneratorHelper.rebuildFeaturesPerStep((ChunkGenerator)this, (BiomeSource)this.getBiomeSource());
        }
    }

    public String toString() {
        return ChunkGeneratorManagerImpl.printGeneratorInfo("WoVer - Chunk Generator", (ChunkGenerator)this);
    }

    public void appendFeaturesPerStep() {
    }

    public Registry<LevelStem> enforceGeneratorInWorldGenSettings(RegistryAccess access, ResourceKey<LevelStem> dimensionKey, ResourceKey<DimensionType> dimensionTypeKey, ChunkGenerator loadedChunkGenerator, Registry<LevelStem> dimensionRegistry) {
        LibWoverWorldGenerator.C.log.info("Enforcing Correct Generator for " + dimensionKey.location().toString() + ".");
        WoverChunkGenerator referenceGenerator = this;
        if (loadedChunkGenerator instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor generator = (ChunkGeneratorAccessor)loadedChunkGenerator;
            if (loadedChunkGenerator instanceof NoiseGeneratorSettingsProvider) {
                NoiseGeneratorSettingsProvider noiseProvider = (NoiseGeneratorSettingsProvider)loadedChunkGenerator;
                if (referenceGenerator instanceof NoiseGeneratorSettingsProvider) {
                    BiomeSource bs;
                    NoiseGeneratorSettingsProvider referenceProvider = (NoiseGeneratorSettingsProvider)referenceGenerator;
                    BiomeSource biomeSource = referenceGenerator.getBiomeSource();
                    if (biomeSource instanceof MergeableBiomeSource) {
                        MergeableBiomeSource mbs = (MergeableBiomeSource)biomeSource;
                        bs = mbs.mergeWithBiomeSource(loadedChunkGenerator.getBiomeSource());
                    } else {
                        bs = referenceGenerator.getBiomeSource();
                    }
                    referenceProvider.wover_getNoiseGeneratorSettingHolders();
                    referenceGenerator = new WoverChunkGenerator(bs, (Holder<NoiseGeneratorSettings>)noiseProvider.wover_getNoiseGeneratorSettingHolders());
                }
            }
        }
        return WoverChunkGeneratorImpl.replaceGenerator(dimensionKey, dimensionTypeKey, access, dimensionRegistry.entrySet(), (ChunkGenerator)referenceGenerator, arg_0 -> dimensionRegistry.get(arg_0), (registry, key, stem) -> registry.register(key, (Object)stem, dimensionRegistry.registrationInfo(key).orElse(RegistrationInfo.BUILT_IN)));
    }

    public static NoiseGeneratorSettings amplifiedNether(BootstrapContext<NoiseGeneratorSettings> bootstapContext) {
        HolderGetter densityGetter = bootstapContext.lookup(Registries.DENSITY_FUNCTION);
        return new NoiseGeneratorSettings(NETHER_NOISE_SETTINGS_AMPLIFIED, Blocks.NETHERRACK.defaultBlockState(), Blocks.LAVA.defaultBlockState(), NoiseRouterData.noNewCaves((HolderGetter)densityGetter, (HolderGetter)bootstapContext.lookup(Registries.NOISE), (DensityFunction)NoiseRouterData.slideNetherLike((HolderGetter)densityGetter, (int)0, (int)256)), SurfaceRuleData.nether(), List.of(), 32, false, false, false, true);
    }

    public void wover_injectSurfaceRules(Registry<LevelStem> dimensionRegistry, ResourceKey<LevelStem> dimensionKey) {
        SurfaceRuleUtil.injectNoiseBasedSurfaceRules(dimensionKey, (Holder)this.generatorSettings(), (BiomeSource)this.getBiomeSource());
    }
}

