/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.ambertation.wunderlib.utils.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.betterx.wover.core.api.IntegrationCore;
import org.betterx.wover.core.api.Logger;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverEvents;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.DimensionsWrapper;
import org.betterx.wover.generator.impl.preset.PresetRegistryImpl;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoRegistry;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.state.api.WorldConfig;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;

public class WorldGeneratorConfigImpl {
    public static final String TAG_PRESET = "preset";
    private static final String LEGACY_TAG_GENERATOR = "generator";
    public static final String TAG_DIMENSIONS = "dimensions";
    public static final String TAG_DIMENSION_PRESETS = "world_presets";
    private static final String LEGACY_TAG_VERSION = "version";
    private static final String LEGACY_TAG_BN_GEN_VERSION = "generator_version";
    private static DimensionsWrapper DEFAULT_DIMENSIONS_WRAPPER = null;

    @NotNull
    static CompoundTag getPresetsNbt() {
        return WorldConfig.getCompoundTag((ModCore)LibWoverWorldGenerator.C, (String)TAG_PRESET);
    }

    @NotNull
    static CompoundTag getPresetsNbtFromFolder(LevelStorageSource.LevelStorageAccess levelStorageAccess) {
        File dataDir = levelStorageAccess.getLevelPath(LevelResource.ROOT).resolve("data").toFile();
        File nbtFile = new File(dataDir, LibWoverWorldGenerator.C.modId + ".nbt");
        CompoundTag root = null;
        if (nbtFile.exists()) {
            try {
                root = NbtIo.readCompressed((Path)nbtFile.toPath(), (NbtAccounter)NbtAccounter.create((long)0x200000L));
            }
            catch (IOException e) {
                LibWoverEvents.C.log.error("NBT loading failed", (Exception)e);
            }
        }
        if (root != null && root.contains(TAG_PRESET)) {
            return root.getCompound(TAG_PRESET);
        }
        return new CompoundTag();
    }

    @NotNull
    private static CompoundTag getLegacyPresetsNbt() {
        return WorldConfig.getCompoundTag((ModCore)LegacyHelper.WORLDS_TOGETHER_CORE, (String)TAG_PRESET);
    }

    private static CompoundTag getLegacyGeneratorNbt() {
        CompoundTag root = WorldConfig.getRootTag((ModCore)LegacyHelper.WORLDS_TOGETHER_CORE);
        if (root.contains(LEGACY_TAG_GENERATOR)) {
            return WorldConfig.getCompoundTag((ModCore)LegacyHelper.WORLDS_TOGETHER_CORE, (String)LEGACY_TAG_GENERATOR);
        }
        return null;
    }

    public static void writeWorldPresetSettingsDirect(Map<ResourceKey<LevelStem>, ChunkGenerator> settings) {
        DimensionsWrapper wrapper = new DimensionsWrapper(settings);
        WorldGeneratorConfigImpl.writeWorldPresetSettings(wrapper);
    }

    private static void writeWorldPresetSettings(DimensionsWrapper wrapper) {
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)WorldState.allStageRegistryAccess());
        DataResult encodeResult = DimensionsWrapper.CODEC.encodeStart((DynamicOps)registryOps, (Object)wrapper);
        if (encodeResult.result().isPresent()) {
            CompoundTag settingsNbt = WorldConfig.getRootTag((ModCore)LibWoverWorldGenerator.C);
            settingsNbt.put(TAG_PRESET, (Tag)encodeResult.result().get());
        } else {
            LibWoverWorldGenerator.C.log.error("Unable to encode world generator settings for level.dat.");
        }
        WorldConfig.saveFile((ModCore)LibWoverWorldGenerator.C);
    }

    public static void migrateGeneratorSettings() {
        CompoundTag settingsNbt = WorldGeneratorConfigImpl.getPresetsNbt();
        if (settingsNbt.isEmpty()) {
            WorldDimensions dimensions;
            boolean isPre18;
            CompoundTag wtGen = WorldGeneratorConfigImpl.getLegacyPresetsNbt();
            if (wtGen != null && wtGen.contains(TAG_DIMENSIONS)) {
                LibWoverWorldGenerator.C.log.info("Found World with WorldsTogether Settings.");
                CompoundTag newPresets = WorldGeneratorConfigImpl.getPresetsNbt();
                newPresets.put(TAG_DIMENSIONS, wtGen.get(TAG_DIMENSIONS));
                WorldConfig.saveFile((ModCore)LibWoverWorldGenerator.C);
                return;
            }
            CompoundTag oldGen = WorldGeneratorConfigImpl.getLegacyGeneratorNbt();
            if (oldGen != null && oldGen.contains("type")) {
                LibWoverWorldGenerator.C.log.info("Found World with beta generator Settings.");
                if ("bclib:bcl_world_preset_settings".equals(oldGen.getString("type"))) {
                    int netherVersion = 18;
                    int endVersion = 18;
                    if (oldGen.contains("minecraft:the_nether")) {
                        netherVersion = oldGen.getInt("minecraft:the_nether");
                    }
                    if (oldGen.contains("minecraft:the_end")) {
                        endVersion = oldGen.getInt("minecraft:the_end");
                    }
                    netherVersion = netherVersion == 18 ? 0 : (netherVersion == 17 ? 1 : 2);
                    endVersion = endVersion == 18 ? 0 : (endVersion == 17 ? 1 : 2);
                    List<Map<ResourceKey<LevelStem>, ChunkGenerator>> presets = List.of(DimensionsWrapper.getDimensionsMap(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD), DimensionsWrapper.getDimensionsMap(PresetRegistryImpl.BCL_WORLD_17), DimensionsWrapper.getDimensionsMap((ResourceKey<WorldPreset>)WorldPresets.NORMAL));
                    HashMap<ResourceKey<LevelStem>, ChunkGenerator> dimensions2 = new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
                    dimensions2.put(LevelStem.OVERWORLD, presets.get(0).get(LevelStem.OVERWORLD));
                    dimensions2.put(LevelStem.NETHER, presets.get(netherVersion).get(LevelStem.NETHER));
                    dimensions2.put(LevelStem.END, presets.get(endVersion).get(LevelStem.END));
                    WorldGeneratorConfigImpl.writeWorldPresetSettingsDirect(dimensions2);
                }
                return;
            }
            LibWoverWorldGenerator.C.log.info("Found World without generator Settings. Setting up data...");
            ResourceKey<WorldPreset> biomeSourceVersion = org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD;
            CompoundTag bclRoot = WorldConfig.getRootTag((ModCore)LegacyHelper.BCLIB_CORE);
            Version bclVersion = new Version("0.0.0");
            if (bclRoot.contains(LEGACY_TAG_VERSION)) {
                bclVersion = new Version(bclRoot.getString(LEGACY_TAG_VERSION));
            }
            boolean bl = isPre18 = !bclVersion.isLargerOrEqualVersion("1.0.0");
            if (isPre18) {
                LibWoverWorldGenerator.C.log.info("World was create pre 1.18!");
                biomeSourceVersion = PresetRegistryImpl.BCL_WORLD_17;
            }
            if (WorldConfig.hasMod((ModCore)IntegrationCore.BETTER_NETHER)) {
                LibWoverWorldGenerator.C.log.info("Found Data from BetterNether, using for migration.");
                CompoundTag bnRoot = WorldConfig.getRootTag((ModCore)IntegrationCore.BETTER_NETHER);
                ResourceKey<WorldPreset> resourceKey = biomeSourceVersion = "1.17".equals(bnRoot.getString(LEGACY_TAG_BN_GEN_VERSION)) ? PresetRegistryImpl.BCL_WORLD_17 : org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD;
            }
            if ((dimensions = DimensionsWrapper.getDimensions(biomeSourceVersion)) != null) {
                LibWoverWorldGenerator.C.log.info("Set world to BiomeSource Version " + String.valueOf(biomeSourceVersion));
                WorldGeneratorConfigImpl.writeWorldPresetSettings(new DimensionsWrapper(dimensions));
            } else {
                LibWoverWorldGenerator.C.log.error("Failed to set world to BiomeSource Version " + String.valueOf(biomeSourceVersion));
            }
        }
    }

    public static void createWorldConfig(Holder<WorldPreset> currentPreset, WorldDimensions dimensions) {
        if (currentPreset != null && currentPreset.unwrapKey().isPresent()) {
            WorldPresetInfo info = WorldPresetInfoRegistry.getFor(currentPreset);
            ResourceKey presetKey = (ResourceKey)currentPreset.unwrapKey().orElseThrow();
            for (Map.Entry dimEntry : dimensions.dimensions().entrySet()) {
                ChunkGenerator chunkGenerator = ((LevelStem)dimEntry.getValue()).generator();
                if (!(chunkGenerator instanceof ConfiguredChunkGenerator)) continue;
                ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)chunkGenerator;
                ResourceKey secondaryPreset = info.getPresetOverrideRecursive((ResourceKey)dimEntry.getKey());
                if (cfg.wover_getConfiguredWorldPreset() != null) continue;
                cfg.wover_setConfiguredWorldPreset((ResourceKey<WorldPreset>)(secondaryPreset != null ? secondaryPreset : presetKey));
            }
        }
        LibWoverWorldGenerator.C.log.verbose("Creating presets file for new world");
        WorldGeneratorConfigImpl.writeWorldPresetSettingsDirect(DimensionsWrapper.build(dimensions));
    }

    @NotNull
    public static Map<ResourceKey<LevelStem>, ChunkGenerator> loadWorldDimensions(RegistryAccess registryAccess, CompoundTag presetNBT) {
        try {
            RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registryAccess);
            if (DEFAULT_DIMENSIONS_WRAPPER == null) {
                DEFAULT_DIMENSIONS_WRAPPER = new DimensionsWrapper(DimensionsWrapper.getDimensionsMap(registryAccess, (ResourceKey<WorldPreset>)WorldPresetManager.getDefault()));
            }
            if (presetNBT == null || !presetNBT.contains(TAG_DIMENSIONS)) {
                return WorldGeneratorConfigImpl.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
            }
            Optional oLevelStem = DimensionsWrapper.CODEC.parse(new Dynamic((DynamicOps)registryOps, (Object)presetNBT)).resultOrPartial(arg_0 -> ((Logger)LibWoverWorldGenerator.C.log).error(arg_0));
            return oLevelStem.orElse(WorldGeneratorConfigImpl.DEFAULT_DIMENSIONS_WRAPPER).dimensions;
        }
        catch (Exception e) {
            LibWoverWorldGenerator.C.log.error("Failed to load Dimensions", e);
            return WorldGeneratorConfigImpl.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
        }
    }
}

