/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionsWrapper {
    public static final Codec<DimensionsWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.LEVEL_STEM), (Codec)ChunkGenerator.CODEC).optionalFieldOf("dimensions", new HashMap()).forGetter(o -> o.dimensions), (App)Codec.unboundedMap((Codec)ResourceKey.codec((ResourceKey)Registries.LEVEL_STEM), (Codec)ResourceKey.codec((ResourceKey)Registries.WORLD_PRESET)).optionalFieldOf("world_presets", new HashMap()).forGetter(DimensionsWrapper::getDimensionPresets)).apply((Applicative)instance, DimensionsWrapper::fromCodec));
    final Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions;

    static Map<ResourceKey<LevelStem>, ChunkGenerator> build(WorldDimensions dimensions) {
        HashMap<ResourceKey<LevelStem>, ChunkGenerator> map = new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
        for (Map.Entry entry : dimensions.dimensions().entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem stem = (LevelStem)entry.getValue();
            map.put((ResourceKey<LevelStem>)key, stem.generator());
        }
        return map;
    }

    @Nullable
    public static WorldDimensions getDimensions(ResourceKey<WorldPreset> key) {
        RegistryAccess access = WorldState.allStageRegistryAccess();
        if (access == null) {
            LibWoverWorldGenerator.C.log.error("No valid registry found!");
            return null;
        }
        Optional preset = access.registryOrThrow(Registries.WORLD_PRESET).getHolder(key);
        return preset.map(worldPresetReference -> ((WorldPreset)worldPresetReference.value()).createWorldDimensions()).orElse(null);
    }

    @Nullable
    public static WorldDimensions getDimensions(RegistryAccess access, ResourceKey<WorldPreset> key) {
        if (access == null) {
            LibWoverWorldGenerator.C.log.error("No valid registry found!");
            return null;
        }
        Optional preset = access.registryOrThrow(Registries.WORLD_PRESET).getHolder(key);
        if (preset.isEmpty()) {
            return null;
        }
        return ((WorldPreset)((Holder.Reference)preset.get()).value()).createWorldDimensions();
    }

    @NotNull
    public static Map<ResourceKey<LevelStem>, ChunkGenerator> getDimensionsMap(RegistryAccess access, ResourceKey<WorldPreset> key) {
        WorldDimensions reg = DimensionsWrapper.getDimensions(access, key);
        if (reg == null) {
            return new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
        }
        return DimensionsWrapper.build(reg);
    }

    @NotNull
    public static Map<ResourceKey<LevelStem>, ChunkGenerator> getDimensionsMap(ResourceKey<WorldPreset> key) {
        WorldDimensions reg = DimensionsWrapper.getDimensions(key);
        if (reg == null) {
            return new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
        }
        return DimensionsWrapper.build(reg);
    }

    private static DimensionsWrapper fromCodec(Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions, Map<ResourceKey<LevelStem>, ResourceKey<WorldPreset>> presets) {
        for (Map.Entry<ResourceKey<LevelStem>, ChunkGenerator> dimEntry : dimensions.entrySet()) {
            ChunkGenerator chunkGenerator;
            ResourceKey<WorldPreset> preset = presets.get(dimEntry.getKey());
            if (preset == null || !((chunkGenerator = dimEntry.getValue()) instanceof ConfiguredChunkGenerator)) continue;
            ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)chunkGenerator;
            cfg.wover_setConfiguredWorldPreset(preset);
        }
        return new DimensionsWrapper(dimensions);
    }

    DimensionsWrapper(WorldDimensions dimensions) {
        this(DimensionsWrapper.build(dimensions));
    }

    DimensionsWrapper(Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions) {
        this.dimensions = dimensions;
    }

    public Map<ResourceKey<LevelStem>, ResourceKey<WorldPreset>> getDimensionPresets() {
        HashMap<ResourceKey<LevelStem>, ResourceKey<WorldPreset>> map = new HashMap<ResourceKey<LevelStem>, ResourceKey<WorldPreset>>();
        for (Map.Entry<ResourceKey<LevelStem>, ChunkGenerator> dimEntry : this.dimensions.entrySet()) {
            ConfiguredChunkGenerator cfg;
            ChunkGenerator chunkGenerator = dimEntry.getValue();
            if (!(chunkGenerator instanceof ConfiguredChunkGenerator) || (cfg = (ConfiguredChunkGenerator)chunkGenerator).wover_getConfiguredWorldPreset() == null) continue;
            map.put(dimEntry.getKey(), cfg.wover_getConfiguredWorldPreset());
        }
        return map;
    }
}

