/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource.end;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.jetbrains.annotations.ApiStatus;

public class TheEndBiomesHelper {
    @ApiStatus.Internal
    private static Map<TagKey, Set<ResourceKey<Biome>>> END_BIOMES = new HashMap<TagKey, Set<ResourceKey<Biome>>>();

    @ApiStatus.Internal
    public static void add(TagKey<Biome> type, ResourceKey<Biome> biome) {
        if (biome == null) {
            return;
        }
        END_BIOMES.computeIfAbsent(type, t -> new HashSet()).add(biome);
    }

    private static boolean has(TagKey<Biome> type, ResourceKey<Biome> biome) {
        if (biome == null) {
            return false;
        }
        Set<ResourceKey<Biome>> set = END_BIOMES.get(type);
        if (set == null) {
            return false;
        }
        return set.contains(biome);
    }

    public static boolean canGenerateAsMainIslandBiome(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has((TagKey<Biome>)CommonBiomeTags.IS_END_CENTER, biome);
    }

    public static boolean canGenerateAsSmallIslandsBiome(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has((TagKey<Biome>)CommonBiomeTags.IS_SMALL_END_ISLAND, biome);
    }

    public static boolean canGenerateAsHighlandsBiome(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has((TagKey<Biome>)CommonBiomeTags.IS_END_HIGHLAND, biome);
    }

    public static boolean canGenerateAsEndMidlands(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has((TagKey<Biome>)CommonBiomeTags.IS_END_MIDLAND, biome);
    }

    public static boolean canGenerateAsEndBarrens(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.has((TagKey<Biome>)CommonBiomeTags.IS_END_BARRENS, biome);
    }

    public static boolean canGenerateInEnd(ResourceKey<Biome> biome) {
        return TheEndBiomesHelper.canGenerateAsHighlandsBiome(biome) || TheEndBiomesHelper.canGenerateAsEndBarrens(biome) || TheEndBiomesHelper.canGenerateAsEndMidlands(biome) || TheEndBiomesHelper.canGenerateAsSmallIslandsBiome(biome) || TheEndBiomesHelper.canGenerateAsMainIslandBiome(biome);
    }
}

