/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.dimension.LevelStem;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.config.api.DatapackConfigs;
import org.betterx.wover.core.api.IntegrationCore;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.core.api.registry.BuiltInRegistryManager;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnResourceLoad;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.generator.impl.biomesource.WoverBiomeSourceImpl;
import org.betterx.wover.generator.impl.biomesource.end.TheEndBiomesHelper;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.betterx.wover.generator.impl.biomesource.nether.WoverNetherBiomeSource;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.betterx.wover.util.ResourceLocationSet;
import org.jetbrains.annotations.ApiStatus;

public class BiomeSourceManagerImpl {
    public static final ResourceLocation BIOME_CONFIG_FILE = LibWoverWorldGenerator.C.id("biome_config.json");
    public static final ResourceLocation MINECRAFT_WILDCARD = ResourceLocationSet.WildcardResourceLocation.forAllFrom((ModCore)IntegrationCore.MINECRAFT);
    public static final String BIOME_EXCLUSION_TAG = "exclude";
    public static final String NO_FABRIC_REGISTER_TAG = "no_fabric_register";
    public static final String END_CATCH_ALL = "*:is_end";
    public static final String NETHER_CATCH_ALL = "*:is_nether";
    private static final Map<TagKey<Biome>, Set<ResourceLocation>> EXCLUSIONS = new HashMap<TagKey<Biome>, Set<ResourceLocation>>();
    private static final Set<ResourceLocation> FABRIC_EXCLUDES = new ResourceLocationSet();

    public static void register(ResourceLocation location, MapCodec<? extends BiomeSource> codec) {
        BuiltInRegistryManager.register((Registry)BuiltInRegistries.BIOME_SOURCE, (ResourceLocation)location, codec);
    }

    @ApiStatus.Internal
    public static void initialize() {
        BiomeSourceManagerImpl.register(LibWoverWorldGenerator.C.id("nether_biome_source"), WoverNetherBiomeSource.CODEC);
        BiomeSourceManagerImpl.register(LibWoverWorldGenerator.C.id("end_biome_source"), WoverEndBiomeSource.CODEC);
        if (LegacyHelper.isLegacyEnabled()) {
            BiomeSourceManagerImpl.register(LegacyHelper.BCLIB_CORE.id("nether_biome_source"), (MapCodec<? extends BiomeSource>)LegacyHelper.wrap(WoverNetherBiomeSource.CODEC));
            BiomeSourceManagerImpl.register(LegacyHelper.BCLIB_CORE.id("end_biome_source"), (MapCodec<? extends BiomeSource>)LegacyHelper.wrap(WoverEndBiomeSource.CODEC));
        }
        WorldLifecycle.RESOURCES_LOADED.subscribe((Subscriber)((OnResourceLoad)BiomeSourceManagerImpl::onResourcesLoaded));
        DatapackRegistryBuilder.onElementLoad((ResourceKey)BiomeDataRegistry.BIOME_DATA_REGISTRY, BiomeSourceManagerImpl::didLoadBiomeData);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void didLoadBiomeData(ResourceKey<BiomeData> biomeDataKey, BiomeData biomeData) {
        if (biomeDataKey.location().getNamespace().equals("minecraft")) {
            return;
        }
        ResourceKey biomeKey = BiomeDataRegistry.createBiomeKey(biomeDataKey);
        if (FABRIC_EXCLUDES.contains(biomeKey.location())) return;
        if (biomeData.isIntendedFor(BiomeTags.IS_NETHER)) {
            Iterator iterator = biomeData.generationData.parameterPoints().iterator();
            while (iterator.hasNext()) {
                Climate.ParameterPoint param = (Climate.ParameterPoint)iterator.next();
                if (NetherBiomes.canGenerateInNether((ResourceKey)biomeKey)) continue;
                LibWoverWorldGenerator.C.log.verbose("Adding Nether Biome to Fabric: " + String.valueOf(biomeKey.location()) + " (" + String.valueOf(param) + ")");
                NetherBiomes.addNetherBiome((ResourceKey)biomeKey, (Climate.ParameterPoint)param);
            }
            return;
        }
        if (TheEndBiomesHelper.canGenerateInEnd((ResourceKey<Biome>)biomeKey)) return;
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_LAND) || biomeData.isIntendedFor(BiomeTags.IS_END)) {
            if (!TheEndBiomesHelper.canGenerateAsHighlandsBiome((ResourceKey<Biome>)biomeKey)) {
                LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.location()));
                TheEndBiomes.addHighlandsBiome((ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            }
            if (TheEndBiomesHelper.canGenerateAsEndMidlands((ResourceKey<Biome>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.location()));
            TheEndBiomes.addMidlandsBiome((ResourceKey)biomeKey, (ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 0.5f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_HIGHLAND)) {
            if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((ResourceKey<Biome>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.location()));
            TheEndBiomes.addHighlandsBiome((ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_CENTER)) {
            if (TheEndBiomesHelper.canGenerateAsMainIslandBiome((ResourceKey<Biome>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Center Biome to Fabric: " + String.valueOf(biomeKey.location()));
            TheEndBiomes.addMainIslandBiome((ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_SMALL_END_ISLAND)) {
            if (TheEndBiomesHelper.canGenerateAsSmallIslandsBiome((ResourceKey<Biome>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding Small End Island Biome to Fabric: " + String.valueOf(biomeKey.location()));
            TheEndBiomes.addSmallIslandsBiome((ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (biomeData.isIntendedFor(CommonBiomeTags.IS_END_MIDLAND)) {
            if (TheEndBiomesHelper.canGenerateAsEndMidlands((ResourceKey<Biome>)biomeKey)) return;
            if (biomeData instanceof WoverBiomeData) {
                WoverBiomeData woverData = (WoverBiomeData)biomeData;
                if (woverData.parent != null) {
                    LibWoverWorldGenerator.C.log.verbose("Adding End Midland Biome to Fabric: " + String.valueOf(biomeKey.location()));
                    TheEndBiomes.addMidlandsBiome(woverData.parent, (ResourceKey)biomeKey, (double)woverData.genChance);
                    return;
                }
            }
            if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((ResourceKey<Biome>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.location()));
            TheEndBiomes.addHighlandsBiome((ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 0.5f));
            return;
        }
        if (!biomeData.isIntendedFor(CommonBiomeTags.IS_END_BARRENS)) {
            if (!biomeData.isIntendedFor(BiomeTags.IS_END)) return;
            if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((ResourceKey<Biome>)biomeKey)) return;
            LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.location()));
            TheEndBiomes.addHighlandsBiome((ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 1.0f));
            return;
        }
        if (TheEndBiomesHelper.canGenerateAsEndBarrens((ResourceKey<Biome>)biomeKey)) return;
        if (biomeData instanceof WoverBiomeData) {
            WoverBiomeData woverData = (WoverBiomeData)biomeData;
            if (woverData.parent != null) {
                LibWoverWorldGenerator.C.log.verbose("Adding End Barrens Biome to Fabric: " + String.valueOf(biomeKey.location()));
                TheEndBiomes.addBarrensBiome(woverData.parent, (ResourceKey)biomeKey, (double)woverData.genChance);
                return;
            }
        }
        if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((ResourceKey<Biome>)biomeKey)) return;
        LibWoverWorldGenerator.C.log.verbose("Adding End Highland Biome to Fabric: " + String.valueOf(biomeKey.location()));
        TheEndBiomes.addHighlandsBiome((ResourceKey)biomeKey, (double)BiomeSourceManagerImpl.genChance(biomeData, 0.33f));
    }

    private static float genChance(BiomeData data, float defaultChance) {
        float f;
        if (data instanceof WoverBiomeData) {
            WoverBiomeData woverData = (WoverBiomeData)data;
            f = woverData.genChance;
        } else {
            f = defaultChance;
        }
        return f;
    }

    public static void onResourcesLoaded(ResourceManager resourceManager) {
        EXCLUSIONS.clear();
        FABRIC_EXCLUDES.clear();
        FABRIC_EXCLUDES.add(MINECRAFT_WILDCARD);
        DatapackConfigs.instance().runForResource(resourceManager, BIOME_CONFIG_FILE, BiomeSourceManagerImpl::processBiomeConfigs);
        if (WorldState.registryAccess() != null && !EXCLUSIONS.isEmpty()) {
            WorldState.registryAccess().registry(Registries.LEVEL_STEM).ifPresent(levelStems -> levelStems.holders().forEach(holder -> {
                BiomeSource patt0$temp;
                if (holder.isBound() && (patt0$temp = ((LevelStem)holder.value()).generator().getBiomeSource()) instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource bs = (ReloadableBiomeSource)patt0$temp;
                    bs.reloadBiomes();
                }
            }));
        }
    }

    public static Set<ResourceLocation> getExcludedBiomes(TagKey<Biome> tag) {
        return EXCLUSIONS.getOrDefault(tag, Set.of());
    }

    private static void addAllExclusions(List<TagKey<Biome>> tags, ResourceLocation biome) {
        tags.forEach(tag -> EXCLUSIONS.computeIfAbsent((TagKey<Biome>)tag, k -> new ResourceLocationSet()).add(biome));
    }

    private static void addBiomesToExclusion(JsonElement value, Consumer<ResourceLocation> adder) {
        if (value.isJsonPrimitive()) {
            adder.accept(ResourceLocationSet.WildcardResourceLocation.parse((String)value.getAsString()));
        } else if (value.isJsonArray()) {
            value.getAsJsonArray().forEach(v -> adder.accept(ResourceLocationSet.WildcardResourceLocation.parse((String)v.getAsString())));
        }
    }

    private static void processBiomeConfigs(ResourceLocation location, JsonObject root) {
        JsonObject excludes;
        if (root.has(BIOME_EXCLUSION_TAG)) {
            excludes = root.getAsJsonObject(BIOME_EXCLUSION_TAG);
            excludes.asMap().forEach((key, value) -> {
                if (key.equals(END_CATCH_ALL)) {
                    List<TagKey<Biome>> endTags = WoverEndBiomeSource.TAGS;
                    BiomeSourceManagerImpl.addBiomesToExclusion(value, id -> BiomeSourceManagerImpl.addAllExclusions(endTags, id));
                } else if (key.equals(NETHER_CATCH_ALL)) {
                    List<TagKey<Biome>> netherTags = WoverNetherBiomeSource.TAGS;
                    BiomeSourceManagerImpl.addBiomesToExclusion(value, id -> BiomeSourceManagerImpl.addAllExclusions(netherTags, id));
                } else {
                    TagKey tag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)key));
                    Set elements = EXCLUSIONS.computeIfAbsent((TagKey<Biome>)tag, k -> new ResourceLocationSet());
                    BiomeSourceManagerImpl.addBiomesToExclusion(value, elements::add);
                }
            });
        }
        if (root.has(NO_FABRIC_REGISTER_TAG)) {
            excludes = root.getAsJsonArray(NO_FABRIC_REGISTER_TAG);
            excludes.forEach(v -> FABRIC_EXCLUDES.add(ResourceLocationSet.WildcardResourceLocation.parse((String)v.getAsString())));
        }
    }

    public static String printBiomeSourceInfo(BiomeSource biomeSource) {
        Set biomes = Set.of();
        try {
            biomes = biomeSource.possibleBiomes();
        }
        catch (Throwable e) {
            LibWoverWorldGenerator.C.log.warn("Error getting possible biomes from BiomeSource", new Object[]{e});
        }
        return biomeSource.getClass().getSimpleName() + " (" + Integer.toHexString(biomeSource.hashCode()) + ")\n    biomes     = " + biomes.size() + "\n    namespaces = " + WoverBiomeSourceImpl.getNamespaces(biomes);
    }
}

