/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBootstrapContext;
import org.betterx.wover.biome.api.builder.BiomeBuilder;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.generator.api.biomesource.WoverBiomeData;
import org.betterx.wover.generator.impl.biomesource.builder.WoverBiomeKeyImpl;
import org.betterx.wover.generator.impl.biomesource.builder.WrappedWoverBiomeKeyImpl;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WoverBiomeBuilder<B extends BiomeBuilder<B>> {
    public B edge(ResourceKey<Biome> var1);

    public B parent(ResourceKey<Biome> var1);

    public B parent(BiomeKey<?> var1);

    public B terrainHeight(float var1);

    public B genChance(float var1);

    public B edgeSize(int var1);

    public B vertical(boolean var1);

    public static BiomeKey<Wrapped> wrappedKey(@NotNull ResourceKey<Biome> key) {
        return new WrappedWoverBiomeKeyImpl(key.location());
    }

    public static BiomeKey<WoverBiome> biomeKey(@NotNull ResourceLocation location) {
        return new WoverBiomeKeyImpl(location);
    }

    public static abstract class AbstractWoverBiomeBuilder<T extends AbstractWoverBiomeBuilder<T>>
    extends BiomeBuilder.VanillaBuilder<T>
    implements WoverBiomeBuilder<T> {
        protected float terrainHeight = 0.1f;
        protected float genChance = 1.0f;
        protected int edgeSize = 0;
        protected boolean vertical = false;
        @Nullable
        protected ResourceKey<Biome> edge;
        @Nullable
        protected ResourceKey<Biome> parent;

        protected AbstractWoverBiomeBuilder(BiomeBootstrapContext context, BiomeKey<T> key) {
            super(context, key);
        }

        public void registerBiomeData(BootstrapContext<BiomeData> dataContext) {
            dataContext.register(this.key.dataKey, (Object)new WoverBiomeData(this.fogDensity, (ResourceKey<Biome>)this.key.key, new BiomeGenerationDataContainer(this.parameters, this.intendedPlacement), this.terrainHeight, this.genChance, this.edgeSize, this.vertical, this.edge, this.parent));
        }

        @Override
        public T edge(ResourceKey<Biome> edge) {
            this.edge = edge;
            return (T)this;
        }

        @Override
        public T parent(@Nullable ResourceKey<Biome> parent) {
            this.parent = parent;
            return (T)this;
        }

        @Override
        public T parent(@Nullable BiomeKey<?> parent) {
            this.parent = parent == null ? null : parent.key;
            return (T)this;
        }

        @Override
        public T terrainHeight(float height) {
            this.terrainHeight = height;
            return (T)this;
        }

        @Override
        public T genChance(float weight) {
            this.genChance = weight;
            return (T)this;
        }

        @Override
        public T edgeSize(int size) {
            this.edgeSize = size;
            return (T)this;
        }

        @Override
        public T vertical(boolean vertical) {
            this.vertical = vertical;
            return (T)this;
        }
    }

    public static abstract class WoverBiome
    extends AbstractWoverBiomeBuilder<WoverBiome> {
        protected WoverBiome(BiomeBootstrapContext context, BiomeKey<WoverBiome> key) {
            super(context, key);
        }
    }

    public static abstract class Wrapped
    extends BiomeBuilder<Wrapped>
    implements WoverBiomeBuilder<Wrapped> {
        protected Wrapped(BiomeBootstrapContext context, BiomeKey<Wrapped> key) {
            super(context, key);
        }

        public Wrapped isNetherBiome() {
            return (Wrapped)this.intendedPlacement(BiomeTags.IS_NETHER);
        }

        public Wrapped isEndHighlandBiome() {
            return (Wrapped)this.intendedPlacement(CommonBiomeTags.IS_END_HIGHLAND);
        }

        public Wrapped isEndMidlandBiome(BiomeKey<?> parent) {
            this.parent(parent);
            return (Wrapped)this.intendedPlacement(CommonBiomeTags.IS_END_MIDLAND);
        }

        public Wrapped isEndCenterIslandBiome() {
            return (Wrapped)this.intendedPlacement(CommonBiomeTags.IS_END_CENTER);
        }

        public Wrapped isEndBarrensBiome(BiomeKey<?> parent) {
            this.parent(parent);
            return (Wrapped)this.intendedPlacement(CommonBiomeTags.IS_END_BARRENS);
        }

        public Wrapped isEndSmallIslandBiome() {
            return (Wrapped)this.intendedPlacement(CommonBiomeTags.IS_SMALL_END_ISLAND);
        }
    }
}

