/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.events.mixin.create_new_world_folder;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.betterx.wover.events.impl.WorldLifecycleImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DedicatedServerProperties.WorldDimensionData.class})
public class WorldDimensionDataMixin {
    @Shadow
    @Final
    private String levelType;
    @Shadow
    @Final
    private static Map<String, ResourceKey<WorldPreset>> LEGACY_PRESET_NAMES;

    @Inject(method={"create"}, at={@At(value="RETURN")})
    void wover_onCreateWorld(RegistryAccess registryAccess, CallbackInfoReturnable<WorldDimensions> cir) {
        Holder<WorldPreset> holder = this.wover_getWorldPreset(registryAccess);
        WorldDimensions dimensions = (WorldDimensions)cir.getReturnValue();
        WorldLifecycleImpl.CREATED_NEW_WORLD_FOLDER.emit(c -> c.init(WorldState.storageAccess(), registryAccess, holder, dimensions, false));
    }

    @NotNull
    private Holder<WorldPreset> wover_getWorldPreset(RegistryAccess registryAccess) {
        Registry worldPresetRegistry = registryAccess.registryOrThrow(Registries.WORLD_PRESET);
        Holder.Reference reference = (Holder.Reference)worldPresetRegistry.getHolder(WorldPresets.NORMAL).or(() -> worldPresetRegistry.holders().findAny()).orElseThrow();
        Optional<ResourceKey> presetKey = Optional.ofNullable(ResourceLocation.tryParse((String)this.levelType)).map(resourceLocation -> ResourceKey.create((ResourceKey)Registries.WORLD_PRESET, (ResourceLocation)resourceLocation)).or(() -> Optional.ofNullable(LEGACY_PRESET_NAMES.get(this.levelType)));
        Objects.requireNonNull(worldPresetRegistry);
        Holder holder = (Holder)presetKey.flatMap(arg_0 -> ((Registry)worldPresetRegistry).getHolder(arg_0)).orElse(reference);
        return holder;
    }
}

