/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.fluid;

import com.mojang.serialization.Codec;
import dev.architectury.fluid.forge.FluidStackImpl;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class FluidStack
implements DataComponentHolder {
    private static final FluidStackAdapter<Object> ADAPTER = FluidStack.adapt(FluidStack::getValue, FluidStack::new);
    private static final FluidStack EMPTY = new FluidStack(() -> Fluids.EMPTY, 0L, DataComponentPatch.EMPTY);
    public static final Codec<FluidStack> CODEC = ADAPTER.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidStack> STREAM_CODEC = ADAPTER.streamCodec();
    private final Object value;

    private FluidStack(Supplier<Fluid> fluid, long amount, DataComponentPatch patch) {
        this(ADAPTER.create(fluid, amount, patch));
    }

    private FluidStack(Object value) {
        this.value = Objects.requireNonNull(value);
    }

    private Object getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static FluidStackAdapter<Object> adapt(Function<FluidStack, Object> toValue, Function<Object, FluidStack> fromValue) {
        void var1_1;
        return FluidStackImpl.adapt(toValue, (Function<Object, FluidStack>)var1_1);
    }

    public static FluidStack empty() {
        return EMPTY;
    }

    public static FluidStack create(Fluid fluid, long amount, DataComponentPatch patch) {
        if (fluid == Fluids.EMPTY || amount <= 0L) {
            return FluidStack.empty();
        }
        return FluidStack.create(() -> fluid, amount, patch);
    }

    public static FluidStack create(Fluid fluid, long amount) {
        return FluidStack.create(fluid, amount, DataComponentPatch.EMPTY);
    }

    public static FluidStack create(Supplier<Fluid> fluid, long amount, DataComponentPatch patch) {
        if (amount <= 0L) {
            return FluidStack.empty();
        }
        return new FluidStack(fluid, amount, patch);
    }

    public static FluidStack create(Supplier<Fluid> fluid, long amount) {
        return FluidStack.create(fluid, amount, DataComponentPatch.EMPTY);
    }

    public static FluidStack create(Holder<Fluid> fluid, long amount, DataComponentPatch patch) {
        return FluidStack.create((Fluid)fluid.value(), amount, patch);
    }

    public static FluidStack create(Holder<Fluid> fluid, long amount) {
        return FluidStack.create((Fluid)fluid.value(), amount, DataComponentPatch.EMPTY);
    }

    public static FluidStack create(FluidStack stack, long amount) {
        return FluidStack.create(stack.getRawFluidSupplier(), amount, stack.getPatch());
    }

    public static long bucketAmount() {
        return FluidStackHooks.bucketAmount();
    }

    public Fluid getFluid() {
        return this.isEmpty() ? Fluids.EMPTY : this.getRawFluid();
    }

    @Nullable
    public Fluid getRawFluid() {
        return ADAPTER.getFluid(this.value);
    }

    public Supplier<Fluid> getRawFluidSupplier() {
        return ADAPTER.getRawFluidSupplier(this.value);
    }

    public boolean isEmpty() {
        return this.getRawFluid() == Fluids.EMPTY || ADAPTER.getAmount(this.value) <= 0L;
    }

    public long getAmount() {
        return this.isEmpty() ? 0L : ADAPTER.getAmount(this.value);
    }

    public void setAmount(long amount) {
        ADAPTER.setAmount(this.value, amount);
    }

    public void grow(long amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public DataComponentPatch getPatch() {
        return ADAPTER.getPatch(this.value);
    }

    public PatchedDataComponentMap getComponents() {
        return ADAPTER.getComponents(this.value);
    }

    public void applyComponents(DataComponentPatch patch) {
        ADAPTER.applyComponents(this.value, patch);
    }

    public void applyComponents(DataComponentMap patch) {
        ADAPTER.applyComponents(this.value, patch);
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> type, @Nullable T component) {
        return ADAPTER.set(this.value, type, component);
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> type) {
        return ADAPTER.remove(this.value, type);
    }

    @Nullable
    public <T> T update(DataComponentType<T> type, T component, UnaryOperator<T> updater) {
        return ADAPTER.update(this.value, type, component, updater);
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> type, T component, U updateContext, BiFunction<T, U, T> updater) {
        return ADAPTER.update(this.value, type, component, updateContext, updater);
    }

    public Component getName() {
        return FluidStackHooks.getName(this);
    }

    public String getTranslationKey() {
        return FluidStackHooks.getTranslationKey(this);
    }

    public FluidStack copy() {
        return new FluidStack(ADAPTER.copy(this.value));
    }

    public int hashCode() {
        return ADAPTER.hashCode(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidStackEqual((FluidStack)o);
    }

    public boolean isFluidStackEqual(FluidStack other) {
        return this.getFluid() == other.getFluid() && this.getAmount() == other.getAmount() && this.isComponentEqual(other);
    }

    public boolean isFluidEqual(FluidStack other) {
        return this.getFluid() == other.getFluid();
    }

    public boolean isComponentEqual(FluidStack other) {
        DataComponentPatch patch = this.getPatch();
        DataComponentPatch otherPatch = other.getPatch();
        return Objects.equals(patch, otherPatch);
    }

    public static FluidStack read(RegistryFriendlyByteBuf buf) {
        return FluidStackHooks.read(buf);
    }

    public static Optional<FluidStack> read(HolderLookup.Provider provider, Tag tag) {
        return FluidStackHooks.read(provider, tag);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        FluidStackHooks.write(this, buf);
    }

    public Tag write(HolderLookup.Provider provider, Tag tag) {
        return FluidStackHooks.write(provider, this, tag);
    }

    public FluidStack copyWithAmount(long amount) {
        if (this.isEmpty()) {
            return this;
        }
        return new FluidStack(this.getRawFluidSupplier(), amount, this.getPatch());
    }

    @ApiStatus.Internal
    public static void init() {
    }

    @ApiStatus.Internal
    public static interface FluidStackAdapter<T> {
        public T create(Supplier<Fluid> var1, long var2, @Nullable DataComponentPatch var4);

        public Supplier<Fluid> getRawFluidSupplier(T var1);

        public Fluid getFluid(T var1);

        public long getAmount(T var1);

        public void setAmount(T var1, long var2);

        public DataComponentPatch getPatch(T var1);

        public PatchedDataComponentMap getComponents(T var1);

        public void applyComponents(T var1, DataComponentPatch var2);

        public void applyComponents(T var1, DataComponentMap var2);

        @Nullable
        public <D> D set(T var1, DataComponentType<? super D> var2, @Nullable D var3);

        @Nullable
        public <D> D remove(T var1, DataComponentType<? extends D> var2);

        @Nullable
        public <D> D update(T var1, DataComponentType<D> var2, D var3, UnaryOperator<D> var4);

        @Nullable
        public <D, U> D update(T var1, DataComponentType<D> var2, D var3, U var4, BiFunction<D, U, D> var5);

        public T copy(T var1);

        public int hashCode(T var1);

        public Codec<FluidStack> codec();

        public StreamCodec<RegistryFriendlyByteBuf, FluidStack> streamCodec();
    }
}

