/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.event.events.common;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public interface PlayerEvent {
    public static final Event<PlayerJoin> PLAYER_JOIN = EventFactory.createLoop(new PlayerJoin[0]);
    public static final Event<PlayerQuit> PLAYER_QUIT = EventFactory.createLoop(new PlayerQuit[0]);
    public static final Event<PlayerRespawn> PLAYER_RESPAWN = EventFactory.createLoop(new PlayerRespawn[0]);
    public static final Event<PlayerAdvancement> PLAYER_ADVANCEMENT = EventFactory.createLoop(new PlayerAdvancement[0]);
    public static final Event<PlayerClone> PLAYER_CLONE = EventFactory.createLoop(new PlayerClone[0]);
    public static final Event<CraftItem> CRAFT_ITEM = EventFactory.createLoop(new CraftItem[0]);
    public static final Event<SmeltItem> SMELT_ITEM = EventFactory.createLoop(new SmeltItem[0]);
    public static final Event<PickupItemPredicate> PICKUP_ITEM_PRE = EventFactory.createEventResult(new PickupItemPredicate[0]);
    public static final Event<PickupItem> PICKUP_ITEM_POST = EventFactory.createLoop(new PickupItem[0]);
    public static final Event<ChangeDimension> CHANGE_DIMENSION = EventFactory.createLoop(new ChangeDimension[0]);
    public static final Event<DropItem> DROP_ITEM = EventFactory.createEventResult(new DropItem[0]);
    public static final Event<OpenMenu> OPEN_MENU = EventFactory.createLoop(new OpenMenu[0]);
    public static final Event<CloseMenu> CLOSE_MENU = EventFactory.createLoop(new CloseMenu[0]);
    public static final Event<FillBucket> FILL_BUCKET = EventFactory.createCompoundEventResult(new FillBucket[0]);
    public static final Event<AttackEntity> ATTACK_ENTITY = EventFactory.createEventResult(new AttackEntity[0]);

    public static interface PlayerJoin {
        public void join(ServerPlayer var1);
    }

    public static interface PlayerQuit {
        public void quit(ServerPlayer var1);
    }

    public static interface PlayerRespawn {
        public void respawn(ServerPlayer var1, boolean var2, Entity.RemovalReason var3);
    }

    public static interface PlayerAdvancement {
        public void award(ServerPlayer var1, AdvancementHolder var2);
    }

    public static interface PlayerClone {
        public void clone(ServerPlayer var1, ServerPlayer var2, boolean var3);
    }

    public static interface CraftItem {
        public void craft(Player var1, ItemStack var2, Container var3);
    }

    public static interface SmeltItem {
        public void smelt(Player var1, ItemStack var2);
    }

    public static interface PickupItemPredicate {
        public EventResult canPickup(Player var1, ItemEntity var2, ItemStack var3);
    }

    public static interface PickupItem {
        public void pickup(Player var1, ItemEntity var2, ItemStack var3);
    }

    public static interface ChangeDimension {
        public void change(ServerPlayer var1, ResourceKey<Level> var2, ResourceKey<Level> var3);
    }

    public static interface DropItem {
        public EventResult drop(Player var1, ItemEntity var2);
    }

    public static interface OpenMenu {
        public void open(Player var1, AbstractContainerMenu var2);
    }

    public static interface CloseMenu {
        public void close(Player var1, AbstractContainerMenu var2);
    }

    public static interface FillBucket {
        public CompoundEventResult<ItemStack> fill(Player var1, Level var2, ItemStack var3, @Nullable HitResult var4);
    }

    public static interface AttackEntity {
        public EventResult attack(Player var1, Level var2, Entity var3, InteractionHand var4, @Nullable EntityHitResult var5);
    }
}

