/*
 * Decompiled with CFR 0.152.
 */
package com.wooledboots.mixins;

import com.wooledboots.Checks;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VibrationSelector.class})
public class VibrationAcceptorEdits {
    @Inject(at={@At(value="HEAD")}, method={"shouldReplaceVibration"}, cancellable=true)
    void canAccept(VibrationInfo vibration, long tick, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity aliveEntity;
        Entity entity = vibration.entity();
        GameEvent event = (GameEvent)vibration.gameEvent().value();
        if (entity instanceof LivingEntity && Checks.isWearingWooledBoots(aliveEntity = (LivingEntity)entity)) {
            if (event.equals(GameEvent.STEP.value())) {
                cir.setReturnValue((Object)false);
            }
            if (event.equals(GameEvent.HIT_GROUND.value())) {
                cir.setReturnValue((Object)false);
            }
            if (event.equals(GameEvent.PROJECTILE_SHOOT.value())) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

