/*
 * Decompiled with CFR 0.152.
 */
package com.wooledboots.mixins;

import com.wooledboots.Checks;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Block.class})
public abstract class EntityStepsSound
extends BlockBehaviour {
    @Unique
    private Entity entity1 = null;
    @Unique
    private SoundType originalSoundGroup = null;

    public EntityStepsSound(BlockBehaviour.Properties p_60452_) {
        super(p_60452_);
    }

    @Inject(at={@At(value="HEAD")}, method={"stepOn"})
    protected void stepOn(Level world, BlockPos pos, BlockState state, Entity entity, CallbackInfo cir) {
        this.entity1 = entity;
        this.originalSoundGroup = state.getSoundType();
    }

    public void entityInside(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        this.entity1 = entity;
        this.originalSoundGroup = blockState.getSoundType();
        super.entityInside(blockState, level, blockPos, entity);
    }

    @NotNull
    public SoundType getSoundType(@NotNull BlockState blockState) {
        Entity entity;
        SoundType defaultSoundGroup = this.originalSoundGroup;
        if (this.entity1 != null && (entity = this.entity1) instanceof LivingEntity) {
            LivingEntity liEntity = (LivingEntity)entity;
            if (defaultSoundGroup != null) {
                SoundType woolBlockSoundGroup = new SoundType(1.0f, 1.0f, defaultSoundGroup.getBreakSound(), SoundEvents.WOOL_STEP, defaultSoundGroup.getPlaceSound(), defaultSoundGroup.getHitSound(), SoundEvents.WOOL_FALL);
                if (Checks.isWearingWooledBoots(liEntity)) {
                    return woolBlockSoundGroup;
                }
            }
        }
        return super.getSoundType(blockState);
    }
}

