/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgenerators;

import com.denfop.ElectricItem;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.ISubEnum;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiCore;
import com.denfop.items.ItemCore;
import com.denfop.items.energy.ItemPurifier;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Keyboard;
import com.quantumgenerators.ContainerQG;
import com.quantumgenerators.GuiQG;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileQuantumGenerator
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final String texture;
    public final ComponentBaseEnergy energy;
    private final int meta;
    private final int tier;
    public double gen;
    public double genmax;
    private int upgrade;

    public TileQuantumGenerator(int tier, String texture, int meta, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.gen = 5.0 * Math.pow(4.0, tier - 1) / 16.0;
        this.genmax = 5.0 * Math.pow(4.0, tier - 1) / 16.0;
        this.energy = (ComponentBaseEnergy)this.addComponent((AbstractComponent)ComponentBaseEnergy.asBasicSource((EnergyType)EnergyType.QUANTUM, (TileEntityInventory)this, (double)(this.gen * 32.0), (int)tier));
        this.tier = tier;
        this.texture = texture;
        this.meta = meta;
        this.upgrade = 0;
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.gen = nbttagcompound.getDouble("gen");
        this.genmax = nbttagcompound.getDouble("genmax");
        this.upgrade = nbttagcompound.getInt("upgrade");
    }

    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putDouble("genmax", this.genmax);
        nbttagcompound.putDouble("gen", this.gen);
        nbttagcompound.putInt("upgrade", this.upgrade);
        return nbttagcompound;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (!Keyboard.isKeyDown((int)340)) {
            tooltip.add(Localization.translate((String)"press.lshift"));
        }
        if (Keyboard.isKeyDown((int)340)) {
            tooltip.add(Localization.translate((String)"iu.quantumgenerator.info"));
            tooltip.add(Localization.translate((String)"iu.quantumgenerator.info1"));
            tooltip.add(Localization.translate((String)"gui.SuperSolarPanel.generating") + ": " + this.genmax + Localization.translate((String)"iu.machines_work_energy_type_qe"));
        }
    }

    public boolean wrenchCanRemove(Player player) {
        return super.wrenchCanRemove(player) && this.upgrade == 0;
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.gen = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.gen);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        this.energy.setSendingEnabled(true);
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        this.energy.addEnergy(this.gen);
    }

    public void onLoaded() {
        super.onLoaded();
    }

    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof ItemCore && ((ISubEnum)((ItemCore)stack.getItem()).getElement()).getId() == this.meta) {
                if (this.upgrade < 8) {
                    ++this.upgrade;
                    this.gen = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                    this.genmax = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                    this.energy.setCapacity(this.genmax * 32.0);
                    this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.gen));
                    stack.setCount(stack.getCount() - 1);
                    return true;
                }
            } else if (stack.getItem() instanceof ItemPurifier) {
                if (!ElectricItem.manager.canUse(stack, 500.0)) {
                    return super.onActivated(player, hand, side, vec3);
                }
                if (this.upgrade <= -4) {
                    return super.onActivated(player, hand, side, vec3);
                }
                ElectricItem.manager.use(stack, 500.0, null);
                --this.upgrade;
                this.gen = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                this.genmax = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                this.energy.setCapacity(this.genmax * 32.0);
                this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.gen));
                player.getInventory().add(new ItemStack((ItemLike)IUItem.core.getStack(this.meta), 1));
                return true;
            }
        }
        return super.onActivated(player, hand, side, vec3);
    }

    public void updateTileServer(Player entityPlayer, double i) {
        this.gen = i;
        if (this.gen >= this.genmax) {
            this.gen = this.genmax;
        }
        this.energy.setCapacity(this.genmax * 32.0);
        this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.gen));
    }

    public ContainerQG getGuiContainer(Player entityPlayer) {
        return new ContainerQG(entityPlayer, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiQG((ContainerQG)menu);
    }
}

