/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgenerators;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.quantumgenerators.TileBQG;
import com.quantumgenerators.TileGQG;
import com.quantumgenerators.TileHQG;
import com.quantumgenerators.TileKQG;
import com.quantumgenerators.TileNQG;
import com.quantumgenerators.TilePHQG;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum BlockQG implements IMultiTileBlock
{
    phsp_gen(TilePHQG.class, 0),
    nsp_gen(TileNQG.class, 1),
    bsp_gen(TileBQG.class, 2),
    adsp_gen(TileHQG.class, 3),
    grasp_gen(TileGQG.class, 4),
    kvsp_gen(TileKQG.class, 5);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final Rarity rarity;
    private TileEntityBlock dummyTe;
    private BlockState defaultState;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockType;
    int idBlock;

    private BlockQG(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this(teClass, itemMeta, Rarity.UNCOMMON);
    }

    private BlockQG(Class<? extends TileEntityBlock> teClass, int itemMeta, Rarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
    }

    public int getIDBlock() {
        return this.idBlock;
    }

    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    public void buildDummies() {
        if (this.getTeClass() != null) {
            try {
                this.dummyTe = (TileEntityBlock)this.teClass.getConstructors()[0].newInstance(BlockPos.ZERO, this.defaultState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    public void setType(DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    public BlockEntityType<? extends TileEntityBlock> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    public String getMainPath() {
        return "qg";
    }

    public String getName() {
        return this.name();
    }

    public int getId() {
        return this.itemMeta;
    }

    public boolean hasItem() {
        return true;
    }

    public boolean hasUniqueName() {
        return true;
    }

    public String getUniqueName() {
        return "quantum_generators.qg." + this.name();
    }

    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    public boolean hasActive() {
        return false;
    }

    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    public float getHardness() {
        return 3.0f;
    }

    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Machine;
    }

    public boolean allowWrenchRotating() {
        return true;
    }

    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }
}

