/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event.invoker;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class InvokerFactory<T>
implements Function<T[], T> {
    protected final Class<? super T> type;

    protected InvokerFactory(@NotNull Class<? super T> type) {
        Objects.requireNonNull(type, "The type of the invoker factory cannot be null.");
        this.type = type;
    }

    @Contract(pure=true)
    @NotNull
    public Class<? super T> type() {
        return this.type;
    }

    @NotNull
    protected static <T> Method getFunctionalMethod(@NotNull Class<? super T> type) {
        Method listenerMethod = null;
        for (Method method : type.getMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isAbstract(modifiers)) continue;
            if (listenerMethod != null) {
                throw new IllegalArgumentException("The given listener type isn't a functional interface.");
            }
            listenerMethod = method;
        }
        if (listenerMethod == null) {
            throw new IllegalArgumentException("The given listener type isn't a function interface.");
        }
        return listenerMethod;
    }
}

