/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PrimedTnt.class})
public abstract class PrimedTntEntityMixin
extends Entity
implements DynamicLightSource {
    @Unique
    private int startFuseTimer = 80;
    @Unique
    private int lambdynlights$luminance;

    @Shadow
    public abstract int getFuse();

    public PrimedTntEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void onNew(EntityType<? extends PrimedTnt> type, Level level, CallbackInfo ci) {
        this.startFuseTimer = this.getFuse();
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this.level().isClientSide()) {
            if (!LambDynLights.get().config.getTntLightingMode().isEnabled()) {
                return;
            }
            if (this.isRemoved()) {
                this.setDynamicLightEnabled(false);
            } else {
                if (!((Boolean)LambDynLights.get().config.getEntitiesLightSource().get()).booleanValue() || !DynamicLightHandlers.canLightUp(this)) {
                    this.resetDynamicLight();
                } else {
                    this.dynamicLightTick();
                }
                LambDynLights.updateTracking(this);
            }
        }
    }

    @Override
    public void dynamicLightTick() {
        if (this.isOnFire()) {
            this.lambdynlights$luminance = 15;
        } else {
            ExplosiveLightingMode lightingMode = LambDynLights.get().config.getTntLightingMode();
            if (lightingMode == ExplosiveLightingMode.FANCY) {
                int fuse = this.getFuse() / this.startFuseTimer;
                this.lambdynlights$luminance = (int)((double)(-(fuse * fuse)) * 10.0) + 10;
            } else {
                this.lambdynlights$luminance = 10;
            }
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights$luminance;
    }
}

