/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements DynamicLightSource {
    @Unique
    protected int lambdynlights$luminance;
    @Unique
    private Level lambdynlights$lastWorld;

    @Shadow
    public abstract boolean isSpectator();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public void dynamicLightTick() {
        if (!DynamicLightHandlers.canLightUp(this)) {
            this.lambdynlights$luminance = 0;
            return;
        }
        this.lambdynlights$luminance = this.isOnFire() || this.isCurrentlyGlowing() ? 15 : Math.max(DynamicLightHandlers.getLuminanceFrom(this), LambDynLights.getLivingEntityLuminanceFromItems(this));
        if (this.isSpectator()) {
            this.lambdynlights$luminance = 0;
        }
        if (this.lambdynlights$lastWorld != this.level()) {
            this.lambdynlights$lastWorld = this.level();
            this.lambdynlights$luminance = 0;
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights$luminance;
    }
}

