/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements DynamicLightSource {
    @Unique
    protected int lambdynlights$luminance;

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Override
    public void dynamicLightTick() {
        if (!((Boolean)LambDynLights.get().config.getEntitiesLightSource().get()).booleanValue() || !DynamicLightHandlers.canLightUp(this)) {
            this.lambdynlights$luminance = 0;
            return;
        }
        this.lambdynlights$luminance = this.isOnFire() || this.isCurrentlyGlowing() ? 15 : LambDynLights.getLivingEntityLuminanceFromItems((LivingEntity)this);
        int luminance = DynamicLightHandlers.getLuminanceFrom(this);
        if (luminance > this.lambdynlights$luminance) {
            this.lambdynlights$luminance = luminance;
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights$luminance;
    }
}

