/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.gui;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.LambDynLightsCompat;
import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.gui.InnerBackground;
import dev.lambdaurora.lambdynlights.gui.LightSourceListWidget;
import dev.lambdaurora.lambdynlights.gui.RandomPrideFlagBackground;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.DirtTexturedBackground;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.option.SpruceSimpleActionOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.util.RenderUtil;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceContainerWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import dev.lambdaurora.spruceui.widget.container.tabbed.SpruceTabbedWidget;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class SettingsScreen
extends SpruceScreen {
    private static final Background INNER_BACKGROUND = new InnerBackground();
    private static final String DYNAMIC_LIGHT_SOURCES_KEY = "lambdynlights.menu.light_sources";
    private final DynamicLightsConfig config;
    private final Screen parent;
    private final SpruceOption entitiesOption;
    private final SpruceOption selfOption;
    private final SpruceOption waterSensitiveOption;
    private final SpruceOption creeperLightingOption;
    private final SpruceOption tntLightingOption;
    private final SpruceOption resetOption;
    private SpruceTabbedWidget tabbedWidget;

    public SettingsScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"lambdynlights.menu.title"));
        this.parent = parent;
        this.config = LambDynLights.get().config;
        this.entitiesOption = this.config.getEntitiesLightSource().getOption();
        this.selfOption = this.config.getSelfLightSource().getOption();
        this.waterSensitiveOption = this.config.getWaterSensitiveCheck().getOption();
        this.creeperLightingOption = new SpruceCyclingOption("entity.minecraft.creeper", amount -> this.config.setCreeperLightingMode(this.config.getCreeperLightingMode().next()), option -> option.getDisplayText(this.config.getCreeperLightingMode().getTranslatedText()), (Component)Component.translatable((String)"lambdynlights.tooltip.creeper_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}));
        this.tntLightingOption = new SpruceCyclingOption("block.minecraft.tnt", amount -> this.config.setTntLightingMode(this.config.getTntLightingMode().next()), option -> option.getDisplayText(this.config.getTntLightingMode().getTranslatedText()), (Component)Component.translatable((String)"lambdynlights.tooltip.tnt_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}));
        this.resetOption = SpruceSimpleActionOption.reset(btn -> {
            this.config.reset();
            Minecraft client = Minecraft.getInstance();
            this.init(client, client.getWindow().getGuiScaledWidth(), client.getWindow().getGuiScaledHeight());
        });
    }

    public void removed() {
        super.removed();
        this.config.save();
    }

    private int getTextHeight() {
        Objects.requireNonNull(this.font);
        return (5 + 9) * 3 + 5;
    }

    protected void init() {
        super.init();
        MutableComponent dynamicLightSources = Component.translatable((String)DYNAMIC_LIGHT_SOURCES_KEY);
        this.tabbedWidget = new SpruceTabbedWidget(Position.origin(), this.width, this.height, null, Math.max(100, this.width / 8), 0);
        this.tabbedWidget.getList().setBackground(RandomPrideFlagBackground.random());
        this.tabbedWidget.addTabEntry((Component)Component.translatable((String)"lambdynlights.menu.tabs.general"), null, this.tabContainerBuilder(this::buildGeneralTab));
        this.tabbedWidget.addSeparatorEntry(null);
        this.tabbedWidget.addTabEntry((Component)Component.empty().append((Component)dynamicLightSources).append(": ").append(this.entitiesOption.getPrefix()), null, this.tabContainerBuilder(this::buildEntitiesTab));
        this.addWidget((GuiEventListener)this.tabbedWidget);
    }

    private SpruceTabbedWidget.ContainerFactory tabContainerBuilder(SpruceTabbedWidget.ContainerFactory innerFactory) {
        return (width, height) -> this.buildTabContainer(width, height, innerFactory);
    }

    private SpruceContainerWidget buildTabContainer(int width, int height, SpruceTabbedWidget.ContainerFactory factory) {
        SpruceContainerWidget container = new SpruceContainerWidget(Position.origin(), width, height);
        SpruceLabelWidget label = new SpruceLabelWidget(Position.of((int)0, (int)18), (Component)this.title.copy().withStyle(ChatFormatting.WHITE), width);
        label.setCentered(true);
        container.addChild((SpruceWidget)label);
        AbstractSpruceWidget innerWidget = factory.build(width, height - this.getTextHeight() - 29 - (LambDynLightsCompat.isCanvasInstalled() ? 43 : 0));
        innerWidget.getPosition().setRelativeY(43);
        container.addChild((SpruceWidget)innerWidget);
        container.setBackground((graphics, widget, vOffset, mouseX, mouseY, delta) -> {
            if (this.minecraft.level != null) {
                graphics.fillGradient(widget.getX(), widget.getY(), widget.getX() + widget.getWidth(), innerWidget.getY(), -1072689136, -804253680);
                graphics.fillGradient(widget.getX(), innerWidget.getY() + innerWidget.getHeight(), widget.getX() + widget.getWidth(), widget.getY() + widget.getHeight(), -1072689136, -804253680);
            } else {
                DirtTexturedBackground bg = (DirtTexturedBackground)DirtTexturedBackground.NORMAL;
                RenderUtil.renderBackgroundTexture((int)widget.getX(), (int)widget.getY(), (int)widget.getWidth(), (int)(innerWidget.getY() - widget.getY()), (float)((float)vOffset / 32.0f), (int)bg.red(), (int)bg.green(), (int)bg.blue(), (int)bg.alpha());
                RenderUtil.renderBackgroundTexture((int)widget.getX(), (int)(innerWidget.getY() + innerWidget.getHeight()), (int)widget.getWidth(), (int)(widget.getHeight() - (innerWidget.getY() + innerWidget.getHeight())), (float)((float)vOffset / 32.0f), (int)bg.red(), (int)bg.green(), (int)bg.blue(), (int)bg.alpha());
            }
        });
        if (LambDynLightsCompat.isCanvasInstalled()) {
            Objects.requireNonNull(this.font);
            SpruceLabelWidget firstLine = new SpruceLabelWidget(Position.of((int)0, (int)(height - 29 - (5 + 9) * 3)), (Component)Component.translatable((String)"lambdynlights.menu.canvas.1"), width);
            firstLine.setCentered(true);
            container.addChild((SpruceWidget)firstLine);
            label = new SpruceLabelWidget(Position.of((int)0, (int)(firstLine.getY() + firstLine.getHeight() + 5)), (Component)Component.translatable((String)"lambdynlights.menu.canvas.2"), width);
            label.setCentered(true);
            container.addChild((SpruceWidget)label);
        }
        container.addChild(this.resetOption.createWidget(Position.of((SprucePositioned)this, (int)(width / 2 - 155), (int)(height - 29)), 150));
        container.addChild((SpruceWidget)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(width / 2 - 155 + 160), (int)(height - 29)), 150, 20, SpruceTexts.GUI_DONE, btn -> this.minecraft.setScreen(this.parent)));
        return container;
    }

    private SpruceOptionListWidget buildGeneralTab(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.of((int)0, (int)0), width, height);
        list.setBackground(INNER_BACKGROUND);
        list.addSingleOptionEntry(this.config.dynamicLightsModeOption);
        list.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(DYNAMIC_LIGHT_SOURCES_KEY, true, null));
        list.addOptionEntry(this.entitiesOption, this.selfOption);
        list.addOptionEntry(this.waterSensitiveOption, null);
        list.addOptionEntry(this.creeperLightingOption, this.tntLightingOption);
        return list;
    }

    private LightSourceListWidget buildEntitiesTab(int width, int height) {
        return this.buildLightSourcesTab(width, height, BuiltInRegistries.ENTITY_TYPE.stream().map(DynamicLightHandlerHolder::cast).collect(Collectors.toList()));
    }

    private LightSourceListWidget buildLightSourcesTab(int width, int height, List<DynamicLightHandlerHolder<?>> entries) {
        LightSourceListWidget list = new LightSourceListWidget(Position.of((int)0, (int)0), width, height);
        list.setBackground(INNER_BACKGROUND);
        list.addAll(entries);
        return list;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        String version = LambDynLights.get().version();
        graphics.drawString(this.font, version, this.width - this.font.width(version) - 3, 3, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
    }
}

