/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.SimpleColorBackground;
import dev.lambdaurora.spruceui.util.ColorUtil;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import io.github.queerbric.pride.PrideFlag;
import io.github.queerbric.pride.PrideFlagShape;
import io.github.queerbric.pride.PrideFlagShapes;
import io.github.queerbric.pride.PrideFlags;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class RandomPrideFlagBackground
implements Background {
    private static final Background SECOND_LAYER = new SimpleColorBackground(-535818224);
    private static final IntList DEFAULT_RAINBOW_COLORS = IntList.of((int[])new int[]{-65512, -23252, -191, -16744424, -16776967, -7995267});
    private static final PrideFlagShape PROGRESS = PrideFlagShapes.get((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pride", (String)"progress"));
    private static final Random RANDOM = new Random();
    private final PrideFlag flag;
    private final boolean nuhUh;

    RandomPrideFlagBackground(PrideFlag flag, boolean nuhUh) {
        this.flag = flag;
        this.nuhUh = nuhUh;
    }

    private IntList getColors() {
        return this.nuhUh ? DEFAULT_RAINBOW_COLORS : this.flag.getColors();
    }

    public void render(GuiGraphics graphics, SpruceWidget widget, int vOffset, int mouseX, int mouseY, float delta) {
        int x = widget.getX();
        int y = widget.getY();
        int width = widget.getWidth();
        int height = widget.getHeight();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (this.nuhUh || this.flag.getShape() == PrideFlagShapes.get((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pride", (String)"horizontal_stripes"))) {
            Matrix4f model = graphics.pose().last().pose();
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder vertices = tessellator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
            IntList colors = this.getColors();
            float partHeight = (float)height / ((float)colors.size() - 1.0f);
            float rightY = y;
            float leftY = y;
            int[] color = ColorUtil.unpackARGBColor((int)colors.getInt(0));
            RandomPrideFlagBackground.vertex(vertices, model, x + width, rightY + partHeight, 0.0f).setColor(color[0], color[1], color[2], color[3]);
            RandomPrideFlagBackground.vertex(vertices, model, x + width, rightY, 0.0f).setColor(color[0], color[1], color[2], color[3]);
            RandomPrideFlagBackground.vertex(vertices, model, x, leftY, 0.0f).setColor(color[0], color[1], color[2], color[3]);
            rightY += partHeight;
            for (int i = 1; i < colors.size() - 1; ++i) {
                color = ColorUtil.unpackARGBColor((int)colors.getInt(i));
                RandomPrideFlagBackground.vertex(vertices, model, x + width, rightY + partHeight, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                RandomPrideFlagBackground.vertex(vertices, model, x + width, rightY, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                RandomPrideFlagBackground.vertex(vertices, model, x, leftY, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                RandomPrideFlagBackground.vertex(vertices, model, x + width, rightY + partHeight, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                RandomPrideFlagBackground.vertex(vertices, model, x, leftY, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                RandomPrideFlagBackground.vertex(vertices, model, x, leftY + partHeight, 0.0f).setColor(color[0], color[1], color[2], color[3]);
                rightY += partHeight;
                leftY += partHeight;
            }
            color = ColorUtil.unpackARGBColor((int)colors.getInt(colors.size() - 1));
            RandomPrideFlagBackground.vertex(vertices, model, x + width, rightY, 0.0f).setColor(color[0], color[1], color[2], color[3]);
            RandomPrideFlagBackground.vertex(vertices, model, x, leftY, 0.0f).setColor(color[0], color[1], color[2], color[3]);
            RandomPrideFlagBackground.vertex(vertices, model, x, y + height, 0.0f).setColor(color[0], color[1], color[2], color[3]);
            MeshData builtBuffer = vertices.build();
            if (builtBuffer != null) {
                BufferUploader.drawWithShader((MeshData)builtBuffer);
            }
            tessellator.clear();
        } else {
            this.flag.render(graphics.pose(), (float)x, (float)y, (float)widget.getWidth(), (float)widget.getHeight());
        }
        SECOND_LAYER.render(graphics, widget, vOffset, mouseX, mouseY, delta);
        if (this.nuhUh) {
            MutableComponent text = Component.literal((String)"Nuh uh, you're not going to remove this, try harder :3c");
            Font font = Minecraft.getInstance().font;
            List lines = font.split((FormattedText)text, width - 8);
            int n = lines.size();
            Objects.requireNonNull(font);
            int startY = y + height - 24 - n * (9 + 2);
            for (FormattedCharSequence line : lines) {
                graphics.drawCenteredString(font, line, x + width / 2, startY, -65536);
                Objects.requireNonNull(font);
                startY += 9 + 2;
            }
        }
    }

    public static Background random() {
        PrideFlag flag = PrideFlags.getRandomFlag((Random)RANDOM);
        boolean nuhUh = flag == null || flag.getShape() != PROGRESS && RandomPrideFlagBackground.areColorsSpoofed(flag.getColors());
        return new RandomPrideFlagBackground(flag, nuhUh);
    }

    private static boolean areColorsSpoofed(IntList colors) {
        if (colors.size() < 2) {
            return true;
        }
        int maxDist = 0;
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int colorA = (Integer)intListIterator.next();
            IntListIterator intListIterator2 = colors.iterator();
            while (intListIterator2.hasNext()) {
                int colorB = (Integer)intListIterator2.next();
                int dist = RandomPrideFlagBackground.colorDist(colorA, colorB);
                if (dist <= maxDist) continue;
                maxDist = dist;
            }
        }
        return maxDist < 10;
    }

    private static int colorDist(int a, int b) {
        float r = (float)(ColorUtil.argbUnpackRed((int)a) + ColorUtil.argbUnpackRed((int)b)) / 2.0f;
        int deltaR = ColorUtil.argbUnpackRed((int)a) - ColorUtil.argbUnpackRed((int)b);
        int deltaG = ColorUtil.argbUnpackGreen((int)a) - ColorUtil.argbUnpackGreen((int)b);
        int deltaB = ColorUtil.argbUnpackBlue((int)a) - ColorUtil.argbUnpackBlue((int)b);
        return (int)Math.sqrt((2.0f + r / 256.0f) * (float)deltaR * (float)deltaR + (float)(4 * deltaG * deltaG) + (2.0f + (255.0f - r) / 256.0f) * (float)deltaB * (float)deltaB);
    }

    private static VertexConsumer vertex(BufferBuilder builder, Matrix4f matrix, float x, float y, float z) {
        Vector4f vector4f = matrix.transform(new Vector4f(x, y, z, 1.0f));
        return builder.addVertex(vector4f.x(), vector4f.y(), vector4f.z());
    }
}

