/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.engine.SpatialLookupEntry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public final class DynamicLightingEngine {
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private static final int CELL_SIZE = Mth.ceil((double)7.75);
    private static final int MAX_LIGHT_SOURCES = 1024;
    private static final Vec3i[] CELL_OFFSETS = new Vec3i[27];
    private final SpatialLookupEntry[] spatialLookupEntries = new SpatialLookupEntry[1024];
    private final int[] startIndices = new int[1024];

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        BlockPos.MutableBlockPos currentCell = new BlockPos.MutableBlockPos(this.positionToCell(pos.getX()), this.positionToCell(pos.getY()), this.positionToCell(pos.getZ()));
        BlockPos cell = currentCell.immutable();
        for (Vec3i cellOffset : CELL_OFFSETS) {
            int startIndex;
            SpatialLookupEntry entry;
            currentCell.setWithOffset((Vec3i)cell, cellOffset);
            int key = this.getHashFromKey(this.hashCell(currentCell.getX(), currentCell.getY(), currentCell.getZ()));
            for (int i = startIndex = this.startIndices[key]; i < this.spatialLookupEntries.length && (entry = this.spatialLookupEntries[i]) != null && entry.cellKey() == key; ++i) {
                result = DynamicLightingEngine.maxDynamicLightLevel(pos, entry.source(), result);
            }
        }
        return Mth.clamp((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull DynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.getX() - lightSource.getDynamicLightX() + 0.5) * dx + (dy = (double)pos.getY() - lightSource.getDynamicLightY() + 0.5) * dy + (dz = (double)pos.getZ() - lightSource.getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    private int positionToCell(int coord) {
        return coord / CELL_SIZE;
    }

    private int hashCell(int cellX, int cellY, int cellZ) {
        return Math.abs(cellX * 751 + cellY * 86399 + cellZ * 284593);
    }

    private int getHashFromKey(int hash) {
        return hash % 1024;
    }

    public void computeSpatialLookup(Collection<DynamicLightSource> dynamicLightSources) {
        Arrays.fill(this.spatialLookupEntries, null);
        Arrays.fill(this.startIndices, Integer.MAX_VALUE);
        int i = 0;
        for (DynamicLightSource source : dynamicLightSources) {
            int x = (int)source.getDynamicLightX();
            int y = (int)source.getDynamicLightY();
            int z = (int)source.getDynamicLightZ();
            int cellKey = this.getHashFromKey(this.hashCell(this.positionToCell(x), this.positionToCell(y), this.positionToCell(z)));
            this.spatialLookupEntries[i] = new SpatialLookupEntry(cellKey, source);
            if (++i != 1024) continue;
            break;
        }
        Arrays.sort(this.spatialLookupEntries, Comparator.comparingInt(entry -> entry == null ? Integer.MAX_VALUE : entry.cellKey()));
        for (i = 0; i < 1024 && this.spatialLookupEntries[i] != null; ++i) {
            int previousKey;
            int key = this.spatialLookupEntries[i].cellKey();
            int n = previousKey = i == 0 ? Integer.MAX_VALUE : this.spatialLookupEntries[i - 1].cellKey();
            if (key == previousKey) continue;
            this.startIndices[key] = i;
        }
    }

    static {
        int i = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    DynamicLightingEngine.CELL_OFFSETS[i] = new Vec3i(x, y, z);
                    ++i;
                }
            }
        }
    }
}

