/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.accessor.WorldRendererAccessor;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.api.DynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.compat.CompatLayer;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import dev.lambdaurora.lambdynlights.gui.SettingsScreen;
import dev.lambdaurora.lambdynlights.resource.item.ItemLightSources;
import dev.yumi.commons.event.EventManager;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="lambdynlights", dist={Dist.CLIENT})
@EventBusSubscriber
public class LambDynLights {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights");
    public static final EventManager<ResourceLocation> EVENT_MANAGER = new EventManager<ResourceLocation>(ResourceLocation.fromNamespaceAndPath((String)"lambdynlights", (String)"default"), ResourceLocation::parse);
    private static LambDynLights INSTANCE;
    public final DynamicLightsConfig config = new DynamicLightsConfig(this);
    public final ItemLightSources itemLightSources = new ItemLightSources();
    private final DynamicLightingEngine engine = new DynamicLightingEngine();
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final List<DynamicLightSource> toClear = new ArrayList<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private final ModContainer container;
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;

    public LambDynLights(ModContainer container) {
        INSTANCE = this;
        this.container = container;
        LambDynLights.log(LOGGER, "Initializing LambDynamicLights...");
        this.config.load();
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, screen) -> new SettingsScreen(screen)));
    }

    public static void onInitLate() {
        for (IModInfo mod : ModList.get().getMods()) {
            Object entrypoint = mod.getModProperties().get("lambdynamiclights_init");
            if (entrypoint instanceof String) {
                Class<?> clazz;
                String string = (String)entrypoint;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException e) {
                    LambDynLights.warn(LOGGER, "Entrypoint provided by mod " + mod.getModId() + " is not valid. Failed to load class.", e);
                    continue;
                }
                if (!DynamicLightsInitializer.class.isAssignableFrom(clazz)) {
                    LambDynLights.warn(LOGGER, "Entrypoint provided by mod " + mod.getModId() + " is not valid. Initializer doesn't implement DynamicLightsInitializer");
                    continue;
                }
                try {
                    ((DynamicLightsInitializer)clazz.getConstructor(new Class[0]).newInstance(new Object[0])).onInitializeDynamicLights(LambDynLights.get().itemLightSources);
                }
                catch (Throwable e) {
                    LambDynLights.warn(LOGGER, "Entrypoint provided by mod " + mod.getModId() + " is not valid. Failed to initialize!", e);
                }
                continue;
            }
            if (entrypoint == null) continue;
            LambDynLights.warn(LOGGER, "Entrypoint provided by mod " + mod.getModId() + " is not valid. Expected class name as String, got " + entrypoint.getClass().getName() + ".");
        }
        DynamicLightHandlers.registerDefaultHandlers();
    }

    public String version() {
        return this.container.getModInfo().getVersion().toString();
    }

    @SubscribeEvent
    public static void tagsLoaded(TagsUpdatedEvent event) {
        LambDynLights.INSTANCE.itemLightSources.apply(event.getRegistryAccess());
    }

    @SubscribeEvent
    public static void endWorldTick(ClientTickEvent.Post event) {
        LambDynLights.INSTANCE.lightSourcesLock.writeLock().lock();
        LambDynLights.INSTANCE.engine.computeSpatialLookup(LambDynLights.INSTANCE.dynamicLightSources);
        LambDynLights.INSTANCE.toClear.forEach(source -> source.lambdynlights$scheduleTrackedChunksRebuild(Minecraft.getInstance().levelRenderer));
        LambDynLights.INSTANCE.toClear.clear();
        LambDynLights.INSTANCE.lightSourcesLock.writeLock().unlock();
    }

    @SubscribeEvent
    public static void worldRender(RenderFrameEvent.Pre event) {
        if (Minecraft.getInstance().level != null) {
            Minecraft.getInstance().getProfiler().popPush("dynamic_lighting");
            INSTANCE.updateAll(Minecraft.getInstance().levelRenderer);
        }
    }

    public void updateAll(@NotNull LevelRenderer renderer) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.lambdynlights$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull Entity entity, int lightmap) {
        int posLightLevel = (int)this.getDynamicLightLevel(entity.getOnPos());
        int entityLuminance = ((DynamicLightSource)entity).getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightTexture.block((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        this.lightSourcesLock.readLock().lock();
        double light = this.engine.getDynamicLightLevel(pos);
        this.lightSourcesLock.readLock().unlock();
        return light;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightLevel().isClientSide()) {
            return;
        }
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.dynamicLightSources.add(lightSource);
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightLevel().isClientSide()) {
            return false;
        }
        return this.dynamicLightSources.contains(lightSource);
    }

    public int getLightSourcesCount() {
        return this.dynamicLightSources.size();
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            this.toClear.add(lightSource);
            break;
        }
    }

    public void clearLightSources() {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (it.getLuminance() > 0) {
                it.resetDynamicLight();
            }
            this.toClear.add(it);
        }
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (it.getLuminance() > 0) {
                it.resetDynamicLight();
            }
            this.toClear.add(it);
            break;
        }
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof Entity && !(lightSource instanceof Player));
    }

    public void removeCreeperLightSources() {
        this.removeLightSources(entity -> entity instanceof Creeper);
    }

    public void removeTntLightSources() {
        this.removeLightSources(entity -> entity instanceof PrimedTnt);
    }

    public static void log(Logger logger, String msg) {
        if (!SharedConstants.IS_RUNNING_IN_IDE) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.info((String)msg);
    }

    public static void warn(Logger logger, String msg) {
        if (!SharedConstants.IS_RUNNING_IN_IDE) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg);
    }

    public static void warn(Logger logger, String msg, Object ... args) {
        if (!SharedConstants.IS_RUNNING_IN_IDE) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.warn((String)msg, args);
    }

    public static void error(Logger logger, String msg, Object ... args) {
        if (!SharedConstants.IS_RUNNING_IN_IDE) {
            msg = "[LambDynLights] " + (String)msg;
        }
        logger.error((String)msg, args);
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        LambDynLights.scheduleChunkRebuild(renderer, chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        LambDynLights.scheduleChunkRebuild(renderer, BlockPos.getX((long)chunkPos), BlockPos.getY((long)chunkPos), BlockPos.getZ((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.getInstance().level != null) {
            ((WorldRendererAccessor)renderer).lambdynlights$scheduleChunkRebuild(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.asLong();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabled();
        int luminance = lightSource.getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setDynamicLightEnabled(false);
        }
    }

    private static boolean isEyeSubmergedInFluid(LivingEntity entity) {
        if (!((Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get()).booleanValue()) {
            return false;
        }
        BlockPos eyePos = BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ());
        return !entity.level().getFluidState(eyePos).isEmpty();
    }

    public static int getLivingEntityLuminanceFromItems(LivingEntity entity) {
        int luminance;
        block2: {
            CompatLayer compat;
            boolean submergedInFluid = LambDynLights.isEyeSubmergedInFluid(entity);
            luminance = 0;
            for (ItemStack equipped : entity.getAllSlots()) {
                if (equipped.isEmpty()) continue;
                luminance = Math.max(luminance, LambDynLights.getLuminanceFromItemStack(equipped, submergedInFluid));
            }
            if (luminance >= 15) break block2;
            Iterator<Object> iterator = CompatLayer.LAYERS.iterator();
            while (iterator.hasNext() && (luminance = Math.max(luminance, (compat = (CompatLayer)iterator.next()).getLivingEntityLuminanceFromItems(entity, submergedInFluid))) < 15) {
            }
        }
        return luminance;
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack, boolean submergedInWater) {
        return LambDynLights.INSTANCE.itemLightSources.getLuminance(stack, submergedInWater);
    }

    public static LambDynLights get() {
        return INSTANCE;
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class Modbus {
        @SubscribeEvent
        public static void registerReloader(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)LambDynLights.INSTANCE.itemLightSources);
        }
    }
}

