/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.util.Nameable;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum ExplosiveLightingMode implements Nameable
{
    OFF(ChatFormatting.RED, SpruceTexts.OPTIONS_OFF),
    SIMPLE(ChatFormatting.YELLOW, SpruceTexts.OPTIONS_GENERIC_SIMPLE),
    FANCY(ChatFormatting.GREEN, SpruceTexts.OPTIONS_GENERIC_FANCY);

    private final Component translatedText;

    private ExplosiveLightingMode(ChatFormatting formatting, Component translatedText) {
        this.translatedText = translatedText.copy().withStyle(formatting);
    }

    public boolean isEnabled() {
        return this != OFF;
    }

    public ExplosiveLightingMode next() {
        ExplosiveLightingMode[] v = ExplosiveLightingMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public Component getTranslatedText() {
        return this.translatedText;
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    @NotNull
    public static Optional<ExplosiveLightingMode> byId(@NotNull String id) {
        return Arrays.stream(ExplosiveLightingMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }
}

