/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.HumanoidArm;
import snownee.jade.Jade;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.ModIdentification;

public class WailaConfig
implements IWailaConfig {
    public static final Codec<WailaConfig> CODEC = RecordCodecBuilder.create(i -> i.group((App)ConfigGeneral.CODEC.fieldOf("general").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigGeneral.CODEC)).forGetter(WailaConfig::getGeneral), (App)ConfigOverlay.CODEC.fieldOf("overlay").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigOverlay.CODEC)).forGetter(WailaConfig::getOverlay), (App)ConfigFormatting.CODEC.fieldOf("formatting").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigFormatting.CODEC)).forGetter(WailaConfig::getFormatting), (App)ConfigHistory.CODEC.fieldOf("history").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigHistory.CODEC)).forGetter(WailaConfig::getHistory)).apply((Applicative)i, WailaConfig::new));
    private final ConfigGeneral general;
    private final ConfigOverlay overlay;
    private final ConfigFormatting formatting;
    private final ConfigHistory history;

    public WailaConfig(ConfigGeneral general, ConfigOverlay overlay, ConfigFormatting formatting, ConfigHistory history) {
        this.general = general;
        this.overlay = overlay;
        this.formatting = formatting;
        this.history = history;
    }

    @Override
    public ConfigGeneral getGeneral() {
        return this.general;
    }

    @Override
    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    @Override
    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    public ConfigHistory getHistory() {
        return this.history;
    }

    @Override
    public IPluginConfig getPlugin() {
        return PluginConfig.INSTANCE;
    }

    public static class ConfigGeneral
    implements IWailaConfig.IConfigGeneral {
        public static final Codec<ConfigGeneral> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("previewOverlay").orElse((Object)true).forGetter($ -> $.previewOverlay), (App)Codec.BOOL.fieldOf("displayTooltip").orElse((Object)true).forGetter(ConfigGeneral::shouldDisplayTooltip), (App)Codec.BOOL.fieldOf("displayBlocks").orElse((Object)true).forGetter(ConfigGeneral::getDisplayBlocks), (App)Codec.BOOL.fieldOf("displayEntities").orElse((Object)true).forGetter(ConfigGeneral::getDisplayEntities), (App)Codec.BOOL.fieldOf("displayBosses").orElse((Object)true).forGetter(ConfigGeneral::getDisplayBosses), (App)StringRepresentable.fromEnum(IWailaConfig.DisplayMode::values).fieldOf("displayMode").orElse((Object)IWailaConfig.DisplayMode.TOGGLE).forGetter(ConfigGeneral::getDisplayMode), (App)Codec.BOOL.fieldOf("enableTextToSpeech").orElse((Object)false).forGetter(ConfigGeneral::shouldEnableTextToSpeech), (App)StringRepresentable.fromEnum(IWailaConfig.TTSMode::values).fieldOf("ttsMode").orElse((Object)IWailaConfig.TTSMode.PRESS).forGetter(ConfigGeneral::getTTSMode), (App)StringRepresentable.fromEnum(IWailaConfig.FluidMode::values).fieldOf("fluidMode").orElse((Object)IWailaConfig.FluidMode.ANY).forGetter(ConfigGeneral::getDisplayFluids), (App)StringRepresentable.fromEnum(IWailaConfig.PerspectiveMode::values).fieldOf("perspectiveMode").orElse((Object)IWailaConfig.PerspectiveMode.CAMERA).forGetter(ConfigGeneral::getPerspectiveMode), (App)Codec.floatRange((float)0.0f, (float)20.0f).fieldOf("extendedReach").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigGeneral::getExtendedReach), (App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(ConfigGeneral::isDebug), (App)Codec.BOOL.fieldOf("itemModNameTooltip").orElse((Object)true).forGetter(ConfigGeneral::showItemModNameTooltip), (App)StringRepresentable.fromEnum(IWailaConfig.BossBarOverlapMode::values).fieldOf("bossBarOverlapMode").orElse((Object)IWailaConfig.BossBarOverlapMode.PUSH_DOWN).forGetter(ConfigGeneral::getBossBarOverlapMode), (App)Codec.BOOL.fieldOf("builtinCamouflage").orElse((Object)true).forGetter(ConfigGeneral::getBuiltinCamouflage), (App)ExtraOptions.CODEC.orElseGet(() -> (ExtraOptions)JadeCodecs.createFromEmptyMap(ExtraOptions.CODEC.codec())).forGetter($ -> $.extraOptions)).apply((Applicative)i, ConfigGeneral::new));
        public static final List<String> itemModNameTooltipDisabledByMods = Lists.newArrayList((Object[])new String[]{"emi"});
        public boolean previewOverlay;
        private boolean displayTooltip;
        private boolean displayBlocks;
        private boolean displayEntities;
        private boolean displayBosses;
        private IWailaConfig.DisplayMode displayMode;
        private boolean enableTextToSpeech;
        private IWailaConfig.TTSMode ttsMode;
        private IWailaConfig.FluidMode fluidMode;
        private float extendedReach;
        private boolean debug;
        private boolean itemModNameTooltip;
        private IWailaConfig.BossBarOverlapMode bossBarOverlapMode;
        private boolean builtinCamouflage;
        private IWailaConfig.PerspectiveMode perspectiveMode;
        private final ExtraOptions extraOptions;

        public ConfigGeneral(boolean previewOverlay, boolean displayTooltip, boolean displayBlocks, boolean displayEntities, boolean displayBosses, IWailaConfig.DisplayMode displayMode, boolean enableTextToSpeech, IWailaConfig.TTSMode ttsMode, IWailaConfig.FluidMode fluidMode, IWailaConfig.PerspectiveMode perspectiveMode, float extendedReach, boolean debug, boolean itemModNameTooltip, IWailaConfig.BossBarOverlapMode bossBarOverlapMode, boolean builtinCamouflage, ExtraOptions extraOptions) {
            this.previewOverlay = previewOverlay;
            this.displayTooltip = displayTooltip;
            this.displayBlocks = displayBlocks;
            this.displayEntities = displayEntities;
            this.displayBosses = displayBosses;
            this.displayMode = displayMode;
            this.enableTextToSpeech = enableTextToSpeech;
            this.ttsMode = ttsMode;
            this.fluidMode = fluidMode;
            this.perspectiveMode = perspectiveMode;
            this.extendedReach = extendedReach;
            this.debug = debug;
            this.itemModNameTooltip = itemModNameTooltip;
            this.bossBarOverlapMode = bossBarOverlapMode;
            this.builtinCamouflage = builtinCamouflage;
            this.extraOptions = extraOptions;
        }

        public static void init() {
            List<String> names = itemModNameTooltipDisabledByMods.stream().filter(CommonProxy::isModLoaded).map($ -> ModIdentification.getModName($).orElse((String)$)).toList();
            itemModNameTooltipDisabledByMods.clear();
            itemModNameTooltipDisabledByMods.addAll(names);
            IWailaConfig.IConfigGeneral config = IWailaConfig.get().getGeneral();
            boolean hasAccessibilityMod = ClientProxy.hasAccessibilityMod();
            if (config.getAccessibilityModMemory() != hasAccessibilityMod) {
                config.setAccessibilityModMemory(hasAccessibilityMod);
                config.setEnableAccessibilityPlugin(hasAccessibilityMod);
                Jade.CONFIG.save();
            }
        }

        @Override
        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean getDisplayEntities() {
            return this.displayEntities;
        }

        @Override
        public void setDisplayEntities(boolean displayEntities) {
            this.displayEntities = displayEntities;
        }

        @Override
        public boolean getDisplayBlocks() {
            return this.displayBlocks;
        }

        @Override
        public void setDisplayBlocks(boolean displayBlocks) {
            this.displayBlocks = displayBlocks;
        }

        @Override
        public void toggleTTS() {
            this.enableTextToSpeech = !this.enableTextToSpeech;
        }

        @Override
        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        @Override
        public IWailaConfig.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @Override
        public void setDisplayMode(IWailaConfig.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean shouldEnableTextToSpeech() {
            return this.ttsMode == IWailaConfig.TTSMode.TOGGLE && this.enableTextToSpeech;
        }

        @Override
        public IWailaConfig.TTSMode getTTSMode() {
            return this.ttsMode;
        }

        @Override
        public void setTTSMode(IWailaConfig.TTSMode ttsMode) {
            this.ttsMode = ttsMode;
        }

        @Override
        public boolean shouldDisplayFluids() {
            return this.fluidMode != IWailaConfig.FluidMode.NONE;
        }

        @Override
        public IWailaConfig.FluidMode getDisplayFluids() {
            return this.fluidMode;
        }

        @Override
        public void setDisplayFluids(boolean displayFluids) {
            this.fluidMode = displayFluids ? IWailaConfig.FluidMode.ANY : IWailaConfig.FluidMode.NONE;
        }

        @Override
        public void setDisplayFluids(IWailaConfig.FluidMode displayFluids) {
            this.fluidMode = displayFluids;
        }

        @Override
        public float getExtendedReach() {
            return this.extendedReach;
        }

        @Override
        public void setExtendedReach(float extendedReach) {
            this.extendedReach = Mth.clamp((float)extendedReach, (float)0.0f, (float)20.0f);
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void setItemModNameTooltip(boolean itemModNameTooltip) {
            this.itemModNameTooltip = itemModNameTooltip;
        }

        @Override
        public boolean showItemModNameTooltip() {
            return this.itemModNameTooltip && itemModNameTooltipDisabledByMods.isEmpty();
        }

        @Override
        public IWailaConfig.BossBarOverlapMode getBossBarOverlapMode() {
            return this.bossBarOverlapMode;
        }

        @Override
        public void setBossBarOverlapMode(IWailaConfig.BossBarOverlapMode mode) {
            this.bossBarOverlapMode = mode;
        }

        @Override
        public void setHideFromTabList(boolean hideFromTabList) {
            this.extraOptions.setHideFromTabList(hideFromTabList);
        }

        @Override
        public void setHideFromGUIs(boolean hideFromGUIs) {
            this.extraOptions.setHideFromGUIs(hideFromGUIs);
        }

        @Override
        public boolean shouldHideFromTabList() {
            return this.extraOptions.hideFromTabList();
        }

        @Override
        public boolean shouldHideFromGUIs() {
            return this.extraOptions.hideFromGUIs();
        }

        @Override
        public boolean getDisplayBosses() {
            return this.displayBosses;
        }

        @Override
        public void setDisplayBosses(boolean displayBosses) {
            this.displayBosses = displayBosses;
        }

        @Override
        public boolean getBuiltinCamouflage() {
            return this.builtinCamouflage;
        }

        @Override
        public void setBuiltinCamouflage(boolean builtinCamouflage) {
            this.builtinCamouflage = builtinCamouflage;
        }

        @Override
        public boolean getAccessibilityModMemory() {
            return this.extraOptions.accessibilityModMemory();
        }

        @Override
        public void setAccessibilityModMemory(boolean accessibilityModMemory) {
            this.extraOptions.setAccessibilityModMemory(accessibilityModMemory);
        }

        @Override
        public boolean getEnableAccessibilityPlugin() {
            return this.extraOptions.enableAccessibilityPlugin();
        }

        @Override
        public void setEnableAccessibilityPlugin(boolean enableAccessibilityPlugin) {
            this.extraOptions.setEnableAccessibilityPlugin(enableAccessibilityPlugin);
        }

        @Override
        public IWailaConfig.PerspectiveMode getPerspectiveMode() {
            return this.perspectiveMode;
        }

        @Override
        public void setPerspectiveMode(IWailaConfig.PerspectiveMode perspectiveMode) {
            this.perspectiveMode = perspectiveMode;
        }

        public static final class ExtraOptions {
            public static final MapCodec<ExtraOptions> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.fieldOf("hideFromTabList").orElse((Object)true).forGetter(ExtraOptions::hideFromTabList), (App)Codec.BOOL.fieldOf("hideFromGUIs").orElse((Object)true).forGetter(ExtraOptions::hideFromGUIs), (App)Codec.BOOL.fieldOf("accessibilityModMemory").orElse((Object)false).forGetter(ExtraOptions::accessibilityModMemory), (App)Codec.BOOL.fieldOf("enableAccessibilityPlugin").orElse((Object)false).forGetter(ExtraOptions::enableAccessibilityPlugin)).apply((Applicative)i, ExtraOptions::new));
            private boolean hideFromTabList;
            private boolean hideFromGUIs;
            public boolean accessibilityModMemory;
            public boolean enableAccessibilityPlugin;

            public ExtraOptions(boolean hideFromTabList, boolean hideFromGUIs, boolean accessibilityModMemory, boolean enableAccessibilityPlugin) {
                this.hideFromTabList = hideFromTabList;
                this.hideFromGUIs = hideFromGUIs;
                this.accessibilityModMemory = accessibilityModMemory;
                this.enableAccessibilityPlugin = enableAccessibilityPlugin;
            }

            public boolean hideFromTabList() {
                return this.hideFromTabList;
            }

            public boolean hideFromGUIs() {
                return this.hideFromGUIs;
            }

            public boolean accessibilityModMemory() {
                return this.accessibilityModMemory;
            }

            public boolean enableAccessibilityPlugin() {
                return this.enableAccessibilityPlugin;
            }

            public void setHideFromTabList(boolean hideFromTabList) {
                this.hideFromTabList = hideFromTabList;
            }

            public void setHideFromGUIs(boolean hideFromGUIs) {
                this.hideFromGUIs = hideFromGUIs;
            }

            public void setAccessibilityModMemory(boolean accessibilityModMemory) {
                this.accessibilityModMemory = accessibilityModMemory;
            }

            public void setEnableAccessibilityPlugin(boolean enableAccessibilityPlugin) {
                this.enableAccessibilityPlugin = enableAccessibilityPlugin;
            }
        }
    }

    public static class ConfigOverlay
    implements IWailaConfig.IConfigOverlay {
        public static final Codec<ConfigOverlay> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("activeTheme").orElse((Object)Theme.DEFAULT_THEME_ID).forGetter($ -> $.activeTheme), (App)Codec.FLOAT.fieldOf("overlayPosX").orElse((Object)Float.valueOf(0.5f)).forGetter(ConfigOverlay::getOverlayPosX), (App)Codec.FLOAT.fieldOf("overlayPosY").orElse((Object)Float.valueOf(1.0f)).forGetter(ConfigOverlay::getOverlayPosY), (App)Codec.floatRange((float)0.2f, (float)2.0f).fieldOf("overlayScale").orElse((Object)Float.valueOf(1.0f)).forGetter(ConfigOverlay::getOverlayScale), (App)Codec.FLOAT.fieldOf("overlayAnchorX").orElse((Object)Float.valueOf(0.5f)).forGetter(ConfigOverlay::getAnchorX), (App)Codec.FLOAT.fieldOf("overlayAnchorY").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigOverlay::getAnchorY), (App)Codec.BOOL.fieldOf("overlaySquare").orElse((Object)false).forGetter(ConfigOverlay::getSquare), (App)Codec.BOOL.fieldOf("flipMainHand").orElse((Object)false).forGetter(ConfigOverlay::getFlipMainHand), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("autoScaleThreshold").orElse((Object)Float.valueOf(0.4f)).forGetter(ConfigOverlay::getAutoScaleThreshold), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("alpha").orElse((Object)Float.valueOf(0.7f)).forGetter(ConfigOverlay::getAlpha), (App)StringRepresentable.fromEnum(IWailaConfig.IconMode::values).fieldOf("iconMode").orElse((Object)IWailaConfig.IconMode.TOP).forGetter(ConfigOverlay::getIconMode), (App)Codec.BOOL.fieldOf("animation").orElse((Object)true).forGetter(ConfigOverlay::getAnimation), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("disappearingDelay").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigOverlay::getDisappearingDelay)).apply((Applicative)i, ConfigOverlay::new));
        public ResourceLocation activeTheme;
        private float overlayPosX;
        private float overlayPosY;
        private float overlayScale;
        private float overlayAnchorX;
        private float overlayAnchorY;
        private boolean overlaySquare;
        private boolean flipMainHand;
        private float autoScaleThreshold;
        private float alpha;
        private transient Theme activeThemeInstance;
        private IWailaConfig.IconMode iconMode;
        private boolean animation;
        private float disappearingDelay;

        public ConfigOverlay(ResourceLocation activeTheme, float overlayPosX, float overlayPosY, float overlayScale, float overlayAnchorX, float overlayAnchorY, boolean overlaySquare, boolean flipMainHand, float autoScaleThreshold, float alpha, IWailaConfig.IconMode iconMode, boolean animation, float disappearingDelay) {
            this.activeTheme = activeTheme;
            this.overlayPosX = overlayPosX;
            this.overlayPosY = overlayPosY;
            this.overlayScale = overlayScale;
            this.overlayAnchorX = overlayAnchorX;
            this.overlayAnchorY = overlayAnchorY;
            this.overlaySquare = overlaySquare;
            this.flipMainHand = flipMainHand;
            this.autoScaleThreshold = autoScaleThreshold;
            this.alpha = alpha;
            this.iconMode = iconMode;
            this.animation = animation;
            this.disappearingDelay = disappearingDelay;
        }

        @Override
        public float getOverlayPosX() {
            return Mth.clamp((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = Mth.clamp((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayPosY() {
            return Mth.clamp((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = Mth.clamp((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayScale() {
            return this.overlayScale;
        }

        @Override
        public void setOverlayScale(float overlayScale) {
            this.overlayScale = Mth.clamp((float)overlayScale, (float)0.2f, (float)2.0f);
        }

        @Override
        public float getAnchorX() {
            return Mth.clamp((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = Mth.clamp((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getAnchorY() {
            return Mth.clamp((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = Mth.clamp((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        @Override
        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        @Override
        public float tryFlip(float f) {
            if (this.flipMainHand && Minecraft.getInstance().options.mainHand().get() == HumanoidArm.LEFT) {
                f = 1.0f - f;
            }
            return f;
        }

        @Override
        public boolean getSquare() {
            return this.overlaySquare;
        }

        @Override
        public void setSquare(boolean overlaySquare) {
            this.overlaySquare = overlaySquare;
        }

        @Override
        public float getAutoScaleThreshold() {
            return this.autoScaleThreshold;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public void setAlpha(float alpha) {
            this.alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        }

        @Override
        public Theme getTheme() {
            if (this.activeThemeInstance == null) {
                this.applyTheme(this.activeTheme);
            }
            return this.activeThemeInstance;
        }

        @Override
        public void applyTheme(ResourceLocation id) {
            this.activeThemeInstance = IThemeHelper.get().getTheme(id);
            this.activeTheme = this.activeThemeInstance.id;
        }

        @Override
        public IWailaConfig.IconMode getIconMode() {
            return this.iconMode;
        }

        @Override
        public void setIconMode(IWailaConfig.IconMode iconMode) {
            this.iconMode = iconMode;
        }

        @Override
        public boolean shouldShowIcon() {
            return this.iconMode != IWailaConfig.IconMode.HIDE;
        }

        @Override
        public boolean getAnimation() {
            return this.animation;
        }

        @Override
        public void setAnimation(boolean animation) {
            this.animation = animation;
        }

        @Override
        public float getDisappearingDelay() {
            return this.disappearingDelay;
        }

        @Override
        public void setDisappearingDelay(float delay) {
            this.disappearingDelay = delay;
        }
    }

    public static class ConfigFormatting
    implements IWailaConfig.IConfigFormatting {
        public static final Codec<ConfigFormatting> CODEC = RecordCodecBuilder.create(i -> i.group((App)Style.Serializer.CODEC.fieldOf("itemModNameStyle").orElseGet(() -> Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})).forGetter(ConfigFormatting::getItemModNameStyle)).apply((Applicative)i, ConfigFormatting::new));
        private Style itemModNameStyle;

        public ConfigFormatting(Style itemModNameStyle) {
            this.itemModNameStyle = itemModNameStyle;
        }

        @Override
        public Style getItemModNameStyle() {
            return this.itemModNameStyle;
        }

        @Override
        public void setItemModNameStyle(Style itemModNameStyle) {
            this.itemModNameStyle = itemModNameStyle;
        }

        @Override
        public Component registryName(String name) {
            return Component.literal((String)name).withStyle(IThemeHelper.get().isLightColorScheme() ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY);
        }
    }

    public static class ConfigHistory {
        public static final Codec<ConfigHistory> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.optionalFieldOf("hintOverlayToggle", (Object)true).forGetter($ -> $.hintOverlayToggle), (App)Codec.BOOL.optionalFieldOf("hintNarratorToggle", (Object)true).forGetter($ -> $.hintNarratorToggle), (App)Codec.INT.optionalFieldOf("themesHash", (Object)0).forGetter($ -> $.themesHash)).apply((Applicative)i, ConfigHistory::new));
        public boolean hintOverlayToggle;
        public boolean hintNarratorToggle;
        public int themesHash;

        public ConfigHistory(boolean hintOverlayToggle, boolean hintNarratorToggle, int themesHash) {
            this.hintOverlayToggle = hintOverlayToggle;
            this.hintNarratorToggle = hintNarratorToggle;
            this.themesHash = themesHash;
        }
    }
}

