/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.lightengine;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEventListener;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelLightEngine.class})
public abstract class LevelLightEngineMixin
implements LightEventListener,
StarLightLightingProvider {
    @Shadow
    @Nullable
    private LightEngine<?, ?> blockEngine;
    @Shadow
    @Nullable
    private LightEngine<?, ?> skyEngine;
    @Unique
    protected StarLightInterface lightEngine;
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> blockLightMap = new Long2ObjectOpenHashMap();
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> skyLightMap = new Long2ObjectOpenHashMap();

    @Override
    public final StarLightInterface getLightEngine() {
        return this.lightEngine;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/chunk/LightChunkGetter;ZZ)V"}, at={@At(value="TAIL")})
    public void construct(LightChunkGetter chunkProvider, boolean hasBlockLight, boolean hasSkyLight, CallbackInfo ci) {
        this.lightEngine = chunkProvider.getLevel() instanceof Level ? new StarLightInterface(chunkProvider, hasSkyLight, hasBlockLight, (LevelLightEngine)this) : new StarLightInterface(null, hasSkyLight, hasBlockLight, (LevelLightEngine)this);
        this.blockEngine = null;
        this.skyEngine = null;
    }

    @Overwrite
    public void checkBlock(BlockPos pos) {
        this.lightEngine.blockChange(pos.immutable());
    }

    @Overwrite
    public boolean hasLightWork() {
        return this.lightEngine.hasUpdates();
    }

    @Overwrite
    public int runLightUpdates() {
        boolean hadUpdates = this.hasLightWork();
        this.lightEngine.propagateChanges();
        return hadUpdates ? 1 : 0;
    }

    @Overwrite
    public void updateSectionStatus(SectionPos pos, boolean notReady) {
        this.lightEngine.sectionChange(pos, notReady);
    }

    @Overwrite
    public void setLightEnabled(ChunkPos pos, boolean lightEnabled) {
    }

    @Overwrite
    public void propagateLightSources(ChunkPos param0) {
    }

    @Overwrite
    public LayerLightEventListener getLayerListener(LightLayer lightType) {
        return lightType == LightLayer.BLOCK ? this.lightEngine.getBlockReader() : this.lightEngine.getSkyReader();
    }

    @Overwrite
    public void queueSectionData(LightLayer lightType, SectionPos pos, @Nullable DataLayer nibble) {
    }

    @Overwrite
    public String getDebugData(LightLayer lightType, SectionPos pos) {
        return "n/a";
    }

    @Overwrite
    public void retainData(ChunkPos pos, boolean retainData) {
    }

    @Overwrite
    public int getRawBrightness(BlockPos pos, int ambientDarkness) {
        return this.lightEngine.getRawBrightness(pos, ambientDarkness);
    }

    @Overwrite
    public boolean lightOnInSection(SectionPos pos) {
        long key = CoordinateUtils.getChunkKey(pos.getX(), pos.getZ());
        return !(this.lightEngine.hasBlockLight() && this.blockLightMap.get(key) == null || this.lightEngine.hasSkyLight() && this.skyLightMap.get(key) == null);
    }

    @Override
    public void clientUpdateLight(LightLayer lightType, SectionPos pos, DataLayer nibble, boolean trustEdges) {
        if (this.getClass() != LevelLightEngine.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        ChunkAccess chunk = this.getLightEngine().getAnyChunkNow(pos.getX(), pos.getZ());
        switch (lightType) {
            case BLOCK: {
                SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)this.lightEngine.getWorld()));
                blockNibbles[pos.getY() - WorldUtil.getMinLightSection((LevelHeightAccessor)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((ExtendedChunk)chunk).setBlockNibbles(blockNibbles);
                this.lightEngine.getLightAccess().onLightUpdate(LightLayer.BLOCK, pos);
                break;
            }
            case SKY: {
                SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)this.lightEngine.getWorld()));
                skyNibbles[pos.getY() - WorldUtil.getMinLightSection((LevelHeightAccessor)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((ExtendedChunk)chunk).setSkyNibbles(skyNibbles);
                this.lightEngine.getLightAccess().onLightUpdate(LightLayer.SKY, pos);
                break;
            }
        }
    }

    @Override
    public void clientRemoveLightData(ChunkPos chunkPos) {
        if (this.getClass() != LevelLightEngine.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        this.blockLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
        this.skyLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
    }

    @Override
    public void clientChunkLoad(ChunkPos pos, LevelChunk chunk) {
        if (this.getClass() != LevelLightEngine.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        long key = CoordinateUtils.getChunkKey(pos);
        SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.get(key);
        SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.get(key);
        if (blockNibbles != null) {
            ((ExtendedChunk)chunk).setBlockNibbles(blockNibbles);
        }
        if (skyNibbles != null) {
            ((ExtendedChunk)chunk).setSkyNibbles(skyNibbles);
        }
    }
}

