/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.ui.impl.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.betterx.wover.config.api.client.ClientConfigs;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverUi;
import org.betterx.wover.ui.api.VersionChecker;
import org.betterx.wover.ui.impl.client.WoverLayoutScreen;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class UpdatesScreen
extends WoverLayoutScreen {
    static final class_2960 UPDATE_LOGO_LOCATION = LibWoverUi.C.mk("icon_updater.png");

    public UpdatesScreen(@NotNull Runnable onClose) {
        super(onClose, (class_2561)class_2561.method_43471((String)"wover.updates.title"), 10, 10, 10);
    }

    public UpdatesScreen(class_437 parent) {
        super(UpdatesScreen.setScreenOnClose((class_437)parent), (class_2561)class_2561.method_43471((String)"wover.updates.title"), 10, 10, 10);
    }

    public static void showUpdateUI() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> class_310.method_1551().method_1507((class_437)new UpdatesScreen(class_310.method_1551().field_1755)));
        } else {
            class_310.method_1551().method_1507((class_437)new UpdatesScreen(class_310.method_1551().field_1755));
        }
    }

    public class_2960 getUpdaterIcon(ModCore core) {
        CustomValue.CvObject obj;
        CustomValue element;
        if (core.namespace.equals(LibWoverUi.C.namespace)) {
            return UPDATE_LOGO_LOCATION;
        }
        ModContainer nfo = core.modContainer;
        if (nfo != null && (element = nfo.getMetadata().getCustomValue("wover")) != null && (obj = element.getAsObject()) != null) {
            CustomValue icon = obj.get("updater_icon");
            return core.mk(icon.getAsString());
        }
        return null;
    }

    protected LayoutComponent<?, ?> initContent() {
        VerticalStack rows = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fit()).centerHorizontal();
        rows.addMultilineText(UpdatesScreen.fill(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"wover.updates.description")).centerHorizontal();
        rows.addSpacer(8);
        VersionChecker.forEachUpdate((mod, cur, updated) -> {
            ModCore core = ModCore.create((String)mod);
            ModContainer nfo = core.modContainer;
            class_2960 icon = this.getUpdaterIcon(core);
            HorizontalStack row = (HorizontalStack)rows.addRow(UpdatesScreen.fixed((int)320), UpdatesScreen.fit()).centerHorizontal();
            if (icon != null) {
                row.addImage(Value.fit(), Value.fit(), icon, Size.of((int)32));
                row.addSpacer(4);
            } else {
                row.addSpacer(36);
            }
            if (nfo != null) {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)nfo.getMetadata().getName())).setColor(ColorHelper.WHITE);
            } else {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)mod)).setColor(ColorHelper.WHITE);
            }
            row.addSpacer(4);
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)cur));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)" -> "));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)updated)).setColor(ColorHelper.GREEN);
            row.addFiller();
            boolean createdDownloadLink = false;
            if (nfo != null && nfo.getMetadata().getCustomValue("wover") != null && nfo.getMetadata().getCustomValue("wover").getAsObject().get("downloads") != null) {
                CustomValue.CvObject downloadLinks = nfo.getMetadata().getCustomValue("wover").getAsObject().get("downloads").getAsObject();
                String link = null;
                class_5250 name = null;
                if (((Boolean)ClientConfigs.CLIENT.prefereModrinth.get()).booleanValue() && downloadLinks.get("modrinth") != null) {
                    link = downloadLinks.get("modrinth").getAsString();
                    name = class_2561.method_43471((String)"wover.updates.modrinth_link");
                } else if (downloadLinks.get("curseforge") != null) {
                    link = downloadLinks.get("curseforge").getAsString();
                    name = class_2561.method_43471((String)"wover.updates.curseforge_link");
                }
                if (link != null) {
                    createdDownloadLink = true;
                    String finalLink = link;
                    row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)name).onPress(bt -> this.openLink(finalLink)).centerVertical();
                }
            }
            if (!createdDownloadLink && nfo != null && nfo.getMetadata().getContact().get("homepage").isPresent()) {
                row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"wover.updates.download_link")).onPress(bt -> this.openLink((String)nfo.getMetadata().getContact().get("homepage").get())).centerVertical();
            }
        });
        VerticalStack layout = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fill()).centerHorizontal();
        layout.addScrollable((LayoutComponent)rows);
        layout.addSpacer(8);
        HorizontalStack footer = layout.addRow(UpdatesScreen.fill(), UpdatesScreen.fit());
        footer.addFiller();
        footer.addCheckbox(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"wover.updates.disable_check"), (Boolean)ClientConfigs.CLIENT.checkForNewVersions.get() == false).onChange((cb, state) -> {
            ClientConfigs.CLIENT.checkForNewVersions.set((Object)(!state ? 1 : 0));
            ClientConfigs.CLIENT.save();
        });
        footer.addSpacer(4);
        footer.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), class_5244.field_24334).onPress(bt -> this.method_25419());
        return layout;
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -1120652220);
    }
}

