/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.preset.api.context;

import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class FlatLevelPresetBootstrapContext {
    private final BootstrapContext<FlatLevelGeneratorPreset> context;

    public FlatLevelPresetBootstrapContext(BootstrapContext<FlatLevelGeneratorPreset> context) {
        this.context = context;
    }

    public Holder.Reference<FlatLevelGeneratorPreset> register(ResourceKey<FlatLevelGeneratorPreset> presetKey, ItemLike icon, ResourceKey<Biome> biomeKey, Set<ResourceKey<StructureSet>> allowedStructureSets, boolean addDecorations, boolean addLakes, FlatLayerInfo ... flatLayerInfos) {
        return this.register(presetKey, Lifecycle.stable(), icon, biomeKey, allowedStructureSets, addDecorations, addLakes, flatLayerInfos);
    }

    public Holder.Reference<FlatLevelGeneratorPreset> register(ResourceKey<FlatLevelGeneratorPreset> presetKey, Lifecycle lifecycle, ItemLike icon, ResourceKey<Biome> biomeKey, Set<ResourceKey<StructureSet>> allowedStructureSets, boolean addDecorations, boolean addLakes, FlatLayerInfo ... flatLayerInfos) {
        HolderGetter structureSets = this.context.lookup(Registries.STRUCTURE_SET);
        Objects.requireNonNull(structureSets);
        HolderGetter placedFeatures = this.context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = this.context.lookup(Registries.BIOME);
        HolderSet.Direct structures = HolderSet.direct(allowedStructureSets.stream().map(arg_0 -> ((HolderGetter)structureSets).getOrThrow(arg_0)).toList());
        FlatLevelGeneratorSettings flatLevelGeneratorSettings = new FlatLevelGeneratorSettings(Optional.of(structures), (Holder)biomes.getOrThrow(biomeKey), FlatLevelGeneratorSettings.createLakesList((HolderGetter)placedFeatures));
        if (addDecorations) {
            flatLevelGeneratorSettings.setDecoration();
        }
        if (addLakes) {
            flatLevelGeneratorSettings.setAddLakes();
        }
        for (int i = flatLayerInfos.length - 1; i >= 0; --i) {
            flatLevelGeneratorSettings.getLayersInfo().add(flatLayerInfos[i]);
        }
        return this.context.register(presetKey, (Object)new FlatLevelGeneratorPreset((Holder)icon.asItem().builtInRegistryHolder(), flatLevelGeneratorSettings));
    }

    public HolderGetter<FlatLevelGeneratorPreset> lookup(ResourceKey<? extends Registry<? extends FlatLevelGeneratorPreset>> resourceKey) {
        return this.context.lookup(resourceKey);
    }
}

