/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.creeperfirework.misc;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.component.FireworkExplosion;
import org.jetbrains.annotations.NotNull;

public class FireworkManufacturer {
    public static final Random RNG = new Random();

    public static List<FireworkExplosion> generate(boolean powered) {
        Pair<IntList, IntList> colors = FireworkManufacturer.genFireworkExplosionColorPart();
        ArrayList<FireworkExplosion> ret = new ArrayList<FireworkExplosion>();
        ret.add(new FireworkExplosion(powered ? FireworkExplosion.Shape.SMALL_BALL : FireworkManufacturer.randomSpecialType(), (IntList)colors.left(), (IntList)colors.right(), powered, powered));
        return ret;
    }

    private static FireworkExplosion.Shape randomSpecialType() {
        int i = RNG.nextInt(FireworkExplosion.Shape.values().length - 1) + 1;
        return FireworkExplosion.Shape.values()[i];
    }

    @NotNull
    private static Pair<IntList, IntList> genFireworkExplosionColorPart() {
        int i;
        IntArrayList colors = new IntArrayList();
        IntArrayList fadeColors = new IntArrayList();
        int dyeCount = RNG.nextInt(8) + 1;
        for (i = 0; i < dyeCount; ++i) {
            colors.add(DyeColor.values()[RNG.nextInt(DyeColor.values().length)].getFireworkColor());
        }
        for (i = 0; i < dyeCount; ++i) {
            fadeColors.add(DyeColor.values()[RNG.nextInt(DyeColor.values().length)].getFireworkColor());
        }
        return Pair.of((Object)colors, (Object)fadeColors);
    }
}

