/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.impl.BaseRecipeBuilderImpl;

public class CraftingRecipeBuilderImpl
extends BaseRecipeBuilderImpl<CraftingRecipeBuilder>
implements CraftingRecipeBuilder {
    private String[] shape;
    protected boolean showNotification = true;
    protected final Map<Character, class_1856> materials = new HashMap<Character, class_1856>();

    public CraftingRecipeBuilderImpl(class_2960 id, class_1935 output) {
        super(id, output);
    }

    @Override
    public CraftingRecipeBuilder addMaterial(char key, class_6862<class_1792> value) {
        this.unlockedBy(value);
        return this._addMaterial(key, class_1856.method_8106(value));
    }

    @Override
    public CraftingRecipeBuilder addMaterial(char key, class_1799 ... values) {
        this.unlockedBy(values);
        return this._addMaterial(key, class_1856.method_26964(Arrays.stream(values)));
    }

    @Override
    public CraftingRecipeBuilder addMaterial(char key, class_1935 ... values) {
        this.unlockedBy(values);
        return this._addMaterial(key, class_1856.method_8091((class_1935[])values));
    }

    @Override
    public CraftingRecipeBuilderImpl addMaterial(char key, class_1856 value) {
        this.unlockedBy(value.method_8105());
        return this._addMaterial(key, value);
    }

    public CraftingRecipeBuilderImpl _addMaterial(char key, class_1856 value) {
        this.materials.put(Character.valueOf(key), value);
        return this;
    }

    @Override
    public CraftingRecipeBuilderImpl shape(String ... shape) {
        if (shape.length != 0) {
            for (int i = 1; i < shape.length; ++i) {
                if (shape[i].length() == shape[0].length()) continue;
                throw new IllegalArgumentException("Shape must be rectangular");
            }
        }
        this.shape = shape;
        return this;
    }

    @Override
    public CraftingRecipeBuilder shapeless() {
        this.shape = null;
        return this;
    }

    @Override
    public CraftingRecipeBuilder showNotification() {
        this.showNotification = true;
        return this;
    }

    protected boolean isShaped() {
        return this.shape != null && this.shape.length > 0;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.isShaped()) {
            for (String row2 : this.shape) {
                for (char c : row2.toCharArray()) {
                    if (c == ' ' || this.materials.get(Character.valueOf(c)) != null) continue;
                    this.throwIllegalStateException("Material for character '" + c + "' is not set");
                }
            }
            for (Character m : this.materials.keySet()) {
                if (m.charValue() == ' ') {
                    this.throwIllegalStateException("Material-key for character ' ' is not allowed");
                }
                if (!Arrays.stream(this.shape).noneMatch(row -> row.contains(m.toString()))) continue;
                this.throwIllegalStateException("Material for character '" + m + "' is not used in shape");
            }
        }
    }

    private void buildShaped(class_8790 ctx) {
        class_2447 builder = class_2447.method_10436((class_7800)this.category, (class_1935)this.output.method_7909(), (int)this.output.method_7947());
        for (Map.Entry<Character, class_1856> entry : this.materials.entrySet()) {
            builder.method_10428(entry.getKey(), entry.getValue());
        }
        for (String row : this.shape) {
            builder.method_10439(row);
        }
        if (this.shouldUnlockAdvancements) {
            for (Map.Entry entry : this.unlocks.entrySet()) {
                builder.method_10429((String)entry.getKey(), (class_175)entry.getValue());
            }
        }
        builder.method_49380(this.showNotification);
        builder.method_10435(this.group);
        builder.method_17972(ctx, this.id);
    }

    private void buildShapeless(class_8790 ctx) {
        class_2450 builder = class_2450.method_10448((class_7800)this.category, (class_1935)this.output.method_7909(), (int)this.output.method_7947());
        for (Map.Entry<Character, class_1856> entry : this.materials.entrySet()) {
            builder.method_10451(entry.getValue());
        }
        if (this.shouldUnlockAdvancements) {
            for (Map.Entry<Character, Object> entry : this.unlocks.entrySet()) {
                builder.method_10442((String)((Object)entry.getKey()), (class_175)entry.getValue());
            }
        }
        builder.method_10452(this.group);
        builder.method_17972(ctx, this.id);
    }

    @Override
    public void build(class_8790 ctx) {
        this.validate();
        if (this.isShaped()) {
            this.buildShaped(ctx);
        } else {
            this.buildShapeless(ctx);
        }
    }
}

