/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.impl;

import java.util.Map;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import org.betterx.wover.recipe.api.CookingRecipeBuilder;
import org.betterx.wover.recipe.impl.BaseRecipeBuilderImpl;

public class CookingRecipeBuilderImpl
extends BaseRecipeBuilderImpl<CookingRecipeBuilder>
implements CookingRecipeBuilder {
    protected float xp = 0.0f;
    protected int cookingTime = 200;
    protected class_1856 input;
    protected boolean blasting;
    protected boolean campfire;
    protected boolean smoker;
    protected boolean smelting;

    public CookingRecipeBuilderImpl(class_2960 id, class_1935 output, boolean blasting, boolean campfire, boolean smoker, boolean smelting) {
        super(id, output);
        this.blasting = blasting;
        this.campfire = campfire;
        this.smoker = smoker;
        this.smelting = smelting;
    }

    @Override
    public CookingRecipeBuilder experience(float xp) {
        this.xp = xp;
        return this;
    }

    @Override
    public CookingRecipeBuilder cookingTime(int time) {
        this.cookingTime = time;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableSmelter() {
        this.smelting = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableSmelter() {
        this.smelting = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableBlastFurnace() {
        this.blasting = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableBlastFurnace() {
        this.blasting = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableCampfire() {
        this.campfire = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableCampfire() {
        this.campfire = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder enableSmoker() {
        this.smoker = true;
        return this;
    }

    @Override
    public CookingRecipeBuilder disableSmoker() {
        this.smoker = false;
        return this;
    }

    @Override
    public CookingRecipeBuilder input(class_6862<class_1792> input) {
        return this.input(class_1856.method_8106(input));
    }

    @Override
    public CookingRecipeBuilder input(class_1935 input) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{input}));
    }

    @Override
    public CookingRecipeBuilder input(class_1856 input) {
        this.input = input;
        this.unlockedBy(input.method_8105());
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (!(this.smelting || this.blasting || this.campfire || this.smoker)) {
            this.throwIllegalStateException("No target (smelting, blasting, campfire or somer) for cooking recipe was selected");
        }
        if (this.cookingTime < 0) {
            this.throwIllegalStateException("cooking time must be positive. Recipe {} will be ignored!");
        }
    }

    @Override
    public void build(class_8790 ctx) {
        if (this.smelting) {
            this.buildRecipe(ctx, "smelting", class_2454.method_17802((class_1856)this.input, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)this.cookingTime));
        }
        if (this.blasting) {
            this.buildRecipe(ctx, "blasting", class_2454.method_10473((class_1856)this.input, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)(this.cookingTime / 2)));
        }
        if (this.campfire) {
            this.buildRecipe(ctx, "campfire", class_2454.method_35916((class_1856)this.input, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)(this.cookingTime * 3)));
        }
        if (this.smoker) {
            this.buildRecipe(ctx, "smoker", class_2454.method_35916((class_1856)this.input, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)(this.cookingTime / 2)));
        }
    }

    private void buildRecipe(class_8790 ctx, String suffix, class_2454 builder) {
        class_2960 loc = this.id.method_48331("_" + suffix);
        for (Map.Entry item : this.unlocks.entrySet()) {
            builder.method_10469((String)item.getKey(), (class_175)item.getValue());
        }
        builder.method_17972(ctx, loc);
    }
}

