/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_161;
import net.minecraft.class_1860;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_8779;
import net.minecraft.class_8790;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.jetbrains.annotations.Nullable;

public abstract class WoverRecipeProvider
implements WoverDataProvider<class_2446> {
    public final String title;
    protected final ModCore modCore;

    public WoverRecipeProvider(ModCore modCore, String title) {
        this.title = title;
        this.modCore = modCore;
    }

    protected abstract void bootstrap(class_7225.class_7874 var1, class_8790 var2);

    public class_2446 getProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        return new InnerRecipeProvider(output, registriesFuture){

            @Override
            public void buildRecipes(class_7225.class_7874 lookup, class_8790 exporter) {
                WoverRecipeProvider.this.bootstrap(lookup, exporter);
            }

            @Override
            protected class_2960 getRecipeIdentifier(class_2960 identifier) {
                return identifier;
            }

            public String method_10321() {
                return WoverRecipeProvider.this.title;
            }
        };
    }

    private static abstract class InnerRecipeProvider
    extends class_2446 {
        protected final FabricDataOutput output;

        public InnerRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super((class_7784)output, registriesFuture);
            this.output = output;
        }

        public final void method_10419(class_8790 exporter) {
        }

        public abstract void buildRecipes(class_7225.class_7874 var1, class_8790 var2);

        public CompletableFuture<?> method_56888(final class_7403 writer, final class_7225.class_7874 wrapperLookup) {
            final HashSet generatedRecipes = Sets.newHashSet();
            final ArrayList list = new ArrayList();
            this.buildRecipes(wrapperLookup, new class_8790(){

                public void method_53819(class_2960 recipeId, class_1860<?> recipe, @Nullable class_8779 advancement) {
                    class_2960 identifier = this.getRecipeIdentifier(recipeId);
                    if (!generatedRecipes.add(identifier)) {
                        throw new IllegalStateException("Duplicate recipe " + String.valueOf(identifier));
                    }
                    class_6903 registryOps = wrapperLookup.method_57093((DynamicOps)JsonOps.INSTANCE);
                    JsonObject recipeJson = ((JsonElement)class_1860.field_47319.encodeStart((DynamicOps)registryOps, recipe).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                    ResourceCondition[] conditions = FabricDataGenHelper.consumeConditions(recipe);
                    FabricDataGenHelper.addConditions((JsonObject)recipeJson, (ResourceCondition[])conditions);
                    list.add(class_2405.method_10320((class_7403)writer, (JsonElement)recipeJson, (Path)field_39378.method_44107(identifier)));
                    if (advancement != null) {
                        JsonObject advancementJson = ((JsonElement)class_161.field_47179.encodeStart((DynamicOps)registryOps, (Object)advancement.comp_1920()).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                        FabricDataGenHelper.addConditions((JsonObject)advancementJson, (ResourceCondition[])conditions);
                        list.add(class_2405.method_10320((class_7403)writer, (JsonElement)advancementJson, (Path)field_39379.method_44107(this.getRecipeIdentifier(advancement.comp_1919()))));
                    }
                }

                public class_161.class_162 method_53818() {
                    return class_161.class_162.method_51698().method_708(class_5797.field_39377);
                }
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        }

        protected class_2960 getRecipeIdentifier(class_2960 identifier) {
            return class_2960.method_60655((String)this.output.getModId(), (String)identifier.method_12832());
        }
    }
}

