/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import net.minecraft.class_8052;
import org.betterx.wover.complex.api.equipment.ToolSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolTier {
    public static final ToolSlot.PropertiesBuilder DIGGER_ITEM_PROPERTIES = (slot, tier) -> {
        ToolValues values = tier.getValues(slot);
        if (values == null) {
            throw new IllegalArgumentException("No values for slot " + String.valueOf((Object)slot) + " in tier " + String.valueOf(tier));
        }
        return new class_1792.class_1793().method_57348(class_1766.method_57346((class_1832)tier.toolTier, (float)values.attackDamage, (float)values.attackSpeed));
    };
    public static final ToolSlot.PropertiesBuilder SWORD_ITEM_PROPERTIES = (slot, tier) -> {
        ToolValues values = tier.getValues(slot);
        if (values == null) {
            throw new IllegalArgumentException("No values for slot " + String.valueOf((Object)slot) + " in tier " + String.valueOf(tier));
        }
        return new class_1792.class_1793().method_57348(class_1829.method_57394((class_1832)tier.toolTier, (int)((int)values.attackDamage), (float)values.attackSpeed));
    };
    public final String name;
    public final class_1832 toolTier;
    public final class_6862<class_2248> blockTag;
    private final ToolValues[] toolValues;

    private ToolTier(String name, class_1832 toolTier, ToolValues[] toolValues, class_6862<class_2248> blockTag) {
        this.toolTier = toolTier;
        this.toolValues = toolValues;
        this.name = name;
        this.blockTag = blockTag;
    }

    @Nullable
    public ToolValues getValues(ToolSlot slot) {
        return this.toolValues[slot.slotIndex];
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public String toString() {
        return "ToolTier - " + this.name;
    }

    public ToolTier copyWithOffset(@NotNull String newName, @Nullable class_1832 newTier, ToolValues offset, @Nullable class_6862<class_2248> blockTag) {
        ToolValues[] newValues = new ToolValues[this.toolValues.length];
        for (int i = 0; i < this.toolValues.length; ++i) {
            if (this.toolValues[i] == null) continue;
            newValues[i] = this.toolValues[i].copyWithOffset(offset);
        }
        return new ToolTier(newName, newTier == null ? this.toolTier : newTier, newValues, blockTag);
    }

    public record ToolValues(float attackDamage, float attackSpeed, class_8052 smithingTemplate) {
        public ToolValues(float attackDamage, float attackSpeed) {
            this(attackDamage, attackSpeed, null);
        }

        ToolValues copyWithOffset(ToolValues offset) {
            return new ToolValues(this.attackDamage + offset.attackDamage, this.attackSpeed + offset.attackSpeed, offset.smithingTemplate);
        }
    }

    public static class Builder {
        private class_1832 toolTier;
        private final ToolValues[] toolValues = new ToolValues[ToolSlot.values().length];
        private final String name;
        private class_6862<class_2248> blockTag;

        Builder(String name) {
            this.name = name;
        }

        public Builder blockTag(class_6862<class_2248> blockTag) {
            this.blockTag = blockTag;
            return this;
        }

        public Builder toolTier(class_1832 toolTier) {
            this.toolTier = toolTier;
            return this;
        }

        public Builder toolValues(ToolSlot slot, ToolValues toolValues) {
            this.toolValues[slot.slotIndex] = toolValues;
            return this;
        }

        public Builder toolValuesWithOffset(ToolTier source, ToolValues offset) {
            for (int i = 0; i < this.toolValues.length; ++i) {
                if (source.toolValues[i] == null) continue;
                this.toolValues[i] = source.toolValues[i].copyWithOffset(offset);
            }
            return this;
        }

        public ToolTier build() {
            return new ToolTier(this.name, this.toolTier, this.toolValues, this.blockTag);
        }
    }
}

