/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import java.util.Arrays;
import net.minecraft.class_1741;
import net.minecraft.class_6880;
import net.minecraft.class_8052;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorTier {
    public final class_6880<class_1741> armorMaterial;
    private final ArmorValues[] armorValues;
    public final String name;

    private ArmorTier(String name, class_6880<class_1741> armorMaterial, ArmorValues[] armorValues) {
        this.armorMaterial = armorMaterial;
        this.armorValues = armorValues;
        this.name = name;
    }

    @Nullable
    public ArmorValues getValues(ArmorSlot slot) {
        return this.armorValues[slot.slotIndex];
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean is(class_6880<class_1741> mat) {
        return mat.method_40230().map(arg_0 -> this.armorMaterial.method_40225(arg_0)).orElse(false);
    }

    public String toString() {
        return "ArmorTier - " + this.name;
    }

    public ArmorTier copyWithOffset(@NotNull String newName, @Nullable class_6880<class_1741> newMaterial, ArmorValues offset) {
        ArmorValues[] newValues = new ArmorValues[this.armorValues.length];
        for (int i = 0; i < this.armorValues.length; ++i) {
            if (this.armorValues[i] == null) continue;
            newValues[i] = this.armorValues[i].copyWithOffset(offset);
        }
        return new ArmorTier(newName, newMaterial == null ? this.armorMaterial : newMaterial, newValues);
    }

    public record ArmorValues(int durability, class_8052 smithingTemplate) {
        public ArmorValues(int durability) {
            this(durability, null);
        }

        public ArmorValues copyWithOffset(ArmorValues offset) {
            return new ArmorValues(this.durability + offset.durability, offset.smithingTemplate);
        }
    }

    public static class Builder {
        private class_6880<class_1741> armorMaterial;
        private final ArmorValues[] armorValues = new ArmorValues[ArmorSlot.values().length];
        private final String name;

        public Builder(String name) {
            this.name = name;
        }

        public Builder armorMaterial(class_6880<class_1741> armorMaterial) {
            this.armorMaterial = armorMaterial;
            return this;
        }

        public Builder allArmorValues(ArmorValues armorValues) {
            Arrays.fill(this.armorValues, armorValues);
            return this;
        }

        public Builder armorValues(ArmorSlot slot, ArmorValues armorValues) {
            this.armorValues[slot.slotIndex] = armorValues;
            return this;
        }

        public Builder armorValuesWithOffset(ArmorTier source, ArmorValues offset) {
            for (int i = 0; i < this.armorValues.length; ++i) {
                if (source.armorValues[i] == null) continue;
                this.armorValues[i] = source.armorValues[i].copyWithOffset(offset);
            }
            return this;
        }

        public ArmorTier build() {
            return new ArmorTier(this.name, this.armorMaterial, this.armorValues);
        }
    }
}

