/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.impl.BaseRecipeBuilderImpl;

public class CraftingRecipeBuilderImpl
extends BaseRecipeBuilderImpl<CraftingRecipeBuilder>
implements CraftingRecipeBuilder {
    private String[] shape;
    protected boolean showNotification = true;
    protected final Map<Character, Ingredient> materials = new HashMap<Character, Ingredient>();

    public CraftingRecipeBuilderImpl(ResourceLocation id, ItemLike output) {
        super(id, output);
    }

    @Override
    public CraftingRecipeBuilder addMaterial(char key, TagKey<Item> value) {
        this.unlockedBy(value);
        return this._addMaterial(key, Ingredient.of(value));
    }

    @Override
    public CraftingRecipeBuilder addMaterial(char key, ItemStack ... values) {
        this.unlockedBy(values);
        return this._addMaterial(key, Ingredient.of(Arrays.stream(values)));
    }

    @Override
    public CraftingRecipeBuilder addMaterial(char key, ItemLike ... values) {
        this.unlockedBy(values);
        return this._addMaterial(key, Ingredient.of((ItemLike[])values));
    }

    @Override
    public CraftingRecipeBuilderImpl addMaterial(char key, Ingredient value) {
        this.unlockedBy(value.getItems());
        return this._addMaterial(key, value);
    }

    public CraftingRecipeBuilderImpl _addMaterial(char key, Ingredient value) {
        this.materials.put(Character.valueOf(key), value);
        return this;
    }

    @Override
    public CraftingRecipeBuilderImpl shape(String ... shape) {
        if (shape.length != 0) {
            for (int i = 1; i < shape.length; ++i) {
                if (shape[i].length() == shape[0].length()) continue;
                throw new IllegalArgumentException("Shape must be rectangular");
            }
        }
        this.shape = shape;
        return this;
    }

    @Override
    public CraftingRecipeBuilder shapeless() {
        this.shape = null;
        return this;
    }

    @Override
    public CraftingRecipeBuilder showNotification() {
        this.showNotification = true;
        return this;
    }

    protected boolean isShaped() {
        return this.shape != null && this.shape.length > 0;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.isShaped()) {
            for (String row2 : this.shape) {
                for (char c : row2.toCharArray()) {
                    if (c == ' ' || this.materials.get(Character.valueOf(c)) != null) continue;
                    this.throwIllegalStateException("Material for character '" + c + "' is not set");
                }
            }
            for (Character m : this.materials.keySet()) {
                if (m.charValue() == ' ') {
                    this.throwIllegalStateException("Material-key for character ' ' is not allowed");
                }
                if (!Arrays.stream(this.shape).noneMatch(row -> row.contains(m.toString()))) continue;
                this.throwIllegalStateException("Material for character '" + m + "' is not used in shape");
            }
        }
    }

    private void buildShaped(RecipeOutput ctx) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)this.category, (ItemLike)this.output.getItem(), (int)this.output.getCount());
        for (Map.Entry<Character, Ingredient> entry : this.materials.entrySet()) {
            builder.define(entry.getKey(), entry.getValue());
        }
        for (String row : this.shape) {
            builder.pattern(row);
        }
        if (this.shouldUnlockAdvancements) {
            for (Map.Entry entry : this.unlocks.entrySet()) {
                builder.unlockedBy((String)entry.getKey(), (Criterion)entry.getValue());
            }
        }
        builder.showNotification(this.showNotification);
        builder.group(this.group);
        builder.save(ctx, this.id);
    }

    private void buildShapeless(RecipeOutput ctx) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)this.category, (ItemLike)this.output.getItem(), (int)this.output.getCount());
        for (Map.Entry<Character, Ingredient> entry : this.materials.entrySet()) {
            builder.requires(entry.getValue());
        }
        if (this.shouldUnlockAdvancements) {
            for (Map.Entry<Character, Object> entry : this.unlocks.entrySet()) {
                builder.unlockedBy((String)((Object)entry.getKey()), (Criterion)entry.getValue());
            }
        }
        builder.group(this.group);
        builder.save(ctx, this.id);
    }

    @Override
    public void build(RecipeOutput ctx) {
        this.validate();
        if (this.isShaped()) {
            this.buildShaped(ctx);
        } else {
            this.buildShapeless(ctx);
        }
    }
}

