/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.api;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.recipe.api.CookingRecipeBuilder;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.OnBootstrapRecipes;
import org.betterx.wover.recipe.api.SmithingRecipeBuilder;
import org.betterx.wover.recipe.api.StonecutterRecipeBuilder;
import org.betterx.wover.recipe.impl.CookingRecipeBuilderImpl;
import org.betterx.wover.recipe.impl.CraftingRecipeBuilderImpl;
import org.betterx.wover.recipe.impl.RecipeRuntimeProviderImpl;
import org.betterx.wover.recipe.impl.SmithingRecipeBuilderImpl;
import org.betterx.wover.recipe.impl.StonecutterRecipeBuilderImpl;

public class RecipeBuilder {
    public static Event<OnBootstrapRecipes> BOOTSTRAP_RECIPES = RecipeRuntimeProviderImpl.BOOTSTRAP_RECIPES;

    public static CraftingRecipeBuilder crafting(ResourceLocation id, ItemLike output) {
        return new CraftingRecipeBuilderImpl(id, output);
    }

    public static StonecutterRecipeBuilder stonecutting(ResourceLocation id, ItemLike output) {
        return new StonecutterRecipeBuilderImpl(id, output);
    }

    public static SmithingRecipeBuilder smithing(ResourceLocation id, ItemLike output) {
        return new SmithingRecipeBuilderImpl(id, output);
    }

    public static CookingRecipeBuilder cooking(ResourceLocation id, ItemLike output) {
        return new CookingRecipeBuilderImpl(id, output, false, false, false, false);
    }

    public static CookingRecipeBuilder cookableFood(ResourceLocation id, ItemLike output) {
        return new CookingRecipeBuilderImpl(id, output, false, true, true, false);
    }

    public static CookingRecipeBuilder smelting(ResourceLocation id, ItemLike output) {
        return new CookingRecipeBuilderImpl(id, output, false, false, false, true);
    }

    public static CookingRecipeBuilder blasting(ResourceLocation id, ItemLike output) {
        return new CookingRecipeBuilderImpl(id, output, true, false, false, true);
    }

    public static CookingRecipeBuilder smoker(ResourceLocation id, ItemLike output) {
        return new CookingRecipeBuilderImpl(id, output, false, false, true, false);
    }

    public static CookingRecipeBuilder campfire(ResourceLocation id, ItemLike output) {
        return new CookingRecipeBuilderImpl(id, output, false, true, false, false);
    }

    private static CraftingRecipeBuilder copySmithingTemplateBase(ResourceLocation id, ItemLike filler, ItemLike output) {
        return ((CraftingRecipeBuilder)RecipeBuilder.crafting(id, output).outputCount(2).category(RecipeCategory.MISC)).addMaterial('#', filler).addMaterial('S', output).shape("#S#", "#C#", "###");
    }

    public static CraftingRecipeBuilder copySmithingTemplate(ResourceLocation id, CopySmithingTemplateCostLevel costLevel, ItemLike outputTemplate, ItemLike centerIngredient) {
        return RecipeBuilder.copySmithingTemplateBase(id, (ItemLike)costLevel.priceItem, outputTemplate).addMaterial('C', centerIngredient);
    }

    public static CraftingRecipeBuilder copySmithingTemplate(ResourceLocation id, CopySmithingTemplateCostLevel costLevel, ItemLike outputTemplate, TagKey<Item> centerIngredient) {
        return RecipeBuilder.copySmithingTemplateBase(id, (ItemLike)costLevel.priceItem, outputTemplate).addMaterial('C', centerIngredient);
    }

    public static enum CopySmithingTemplateCostLevel {
        CHEAP(Items.STICK),
        REGULAR(Items.DIAMOND),
        EXPENSIVE(Items.NETHERITE_SCRAP);

        public final Item priceItem;

        private CopySmithingTemplateCostLevel(Item priceItem) {
            this.priceItem = priceItem;
        }
    }

    public static class Templates {
        private static final String[] SHAPE_ROOF = new String[]{"# #", "###", " # "};
        private static final String[] SHAPE_STAIR = new String[]{"#  ", "## ", "###"};
        private static final String[] SHAPE_SLAB = new String[]{"###"};
        private static final String[] SHAPE_BUTTON = new String[]{"#"};
        private static final String[] SHAPE_PLATE = new String[]{"##"};
        private static final String[] SHAPE_X2 = new String[]{"##", "##"};
        private static final String[] SHAPE_3X2 = new String[]{"###", "###"};
        private static final String[] SHAPE_COLORING = new String[]{"###", "#I#", "###"};
        private static final String[] SHAPE_ROUND = new String[]{"###", "# #", "###"};
        private static final String[] SHAPE_FIRE_BOWL = new String[]{"#I#", " # ", "L L"};
        private final ModCore C;
        public final RecipeOutput context;

        public Templates(RecipeOutput context, ModCore modCore) {
            this.C = modCore;
            this.context = context;
        }

        private void makeSingleRecipe(String group, Block source, Block result, String[] shape, int count, RecipeCategory category) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)source).getPath() + "_" + BuiltInRegistries.BLOCK.getKey((Object)result).getPath();
            ((CraftingRecipeBuilder)RecipeBuilder.crafting(this.C.id(name), (ItemLike)result).outputCount(count).group(group).category(category)).shape(shape).addMaterial('#', new ItemLike[]{source}).build(this.context);
        }

        public void makeRoofRecipe(Block source, Block roof) {
            this.makeSingleRecipe("roof_tile", source, roof, SHAPE_ROOF, 6, RecipeCategory.BUILDING_BLOCKS);
        }

        public void makeStairsRecipe(Block source, Block stairs) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)stairs).getPath();
            this.makeSingleRecipe("stairs", source, stairs, SHAPE_STAIR, 4, RecipeCategory.BUILDING_BLOCKS);
            ((StonecutterRecipeBuilder)RecipeBuilder.stonecutting(this.C.id(name + "_stonecutting"), (ItemLike)stairs).outputCount(1).input((ItemLike)source).category(RecipeCategory.BUILDING_BLOCKS)).group("stairs").build(this.context);
        }

        public void makeSlabRecipe(Block source, Block slab) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)slab).getPath();
            this.makeSingleRecipe("slabs", source, slab, SHAPE_SLAB, 6, RecipeCategory.BUILDING_BLOCKS);
            ((StonecutterRecipeBuilder)RecipeBuilder.stonecutting(this.C.id(name + "_stonecutting"), (ItemLike)slab).outputCount(2).input((ItemLike)source).category(RecipeCategory.BUILDING_BLOCKS)).group("slabs").build(this.context);
        }

        public void makeButtonRecipe(Block source, Block button) {
            this.makeSingleRecipe("buttons", source, button, SHAPE_BUTTON, 1, RecipeCategory.REDSTONE);
        }

        public void makePlateRecipe(Block source, Block plate) {
            this.makeSingleRecipe("plates", source, plate, SHAPE_PLATE, 1, RecipeCategory.REDSTONE);
        }

        public void makeSimpleRecipe2x2(Block source, Block result, int count, String group, RecipeCategory category) {
            this.makeSingleRecipe(group, source, result, SHAPE_X2, count, category);
        }

        public void makeWallRecipe(Block source, Block wall) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)wall).getPath();
            ((CraftingRecipeBuilder)RecipeBuilder.crafting(this.C.id(name), (ItemLike)wall).outputCount(6).group("walls").shape(SHAPE_3X2).category(RecipeCategory.DECORATIONS)).addMaterial('#', new ItemLike[]{source}).build(this.context);
            ((StonecutterRecipeBuilder)RecipeBuilder.stonecutting(this.C.id(name + "_stonecutting"), (ItemLike)wall).input((ItemLike)source).category(RecipeCategory.BUILDING_BLOCKS)).group("walls").build(this.context);
        }

        public void makeColoringRecipe(Block source, Block result, Item dye, String group, RecipeCategory category) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)result).getPath();
            ((CraftingRecipeBuilder)RecipeBuilder.crafting(this.C.id(name), (ItemLike)result).outputCount(8).group(group).category(category)).shape(SHAPE_COLORING).addMaterial('#', new ItemLike[]{source}).addMaterial('I', new ItemLike[]{dye}).build(this.context);
        }

        public void makeRoundRecipe(Block source, Block result, String group, RecipeCategory category) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)result).getPath();
            ((CraftingRecipeBuilder)RecipeBuilder.crafting(this.C.id(name), (ItemLike)result).group(group).category(category)).shape(SHAPE_ROUND).addMaterial('#', new ItemLike[]{source}).build(this.context);
        }

        public void makeFireBowlRecipe(Block material, Block inside, Item leg, Block result) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)result).getPath();
            ((CraftingRecipeBuilder)RecipeBuilder.crafting(this.C.id(name), (ItemLike)result).group("fire_bowl").shape(SHAPE_FIRE_BOWL).addMaterial('#', new ItemLike[]{material}).addMaterial('I', new ItemLike[]{inside}).addMaterial('L', new ItemLike[]{leg}).category(RecipeCategory.DECORATIONS)).build(this.context);
        }
    }
}

