/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.jetbrains.annotations.Nullable;

public abstract class WoverRecipeProvider
implements WoverDataProvider<RecipeProvider> {
    public final String title;
    protected final ModCore modCore;

    public WoverRecipeProvider(ModCore modCore, String title) {
        this.title = title;
        this.modCore = modCore;
    }

    protected abstract void bootstrap(HolderLookup.Provider var1, RecipeOutput var2);

    public RecipeProvider getProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        return new InnerRecipeProvider(output, registriesFuture){

            @Override
            public void buildRecipes(HolderLookup.Provider lookup, RecipeOutput exporter) {
                WoverRecipeProvider.this.bootstrap(lookup, exporter);
            }

            @Override
            protected ResourceLocation getRecipeIdentifier(ResourceLocation identifier) {
                return identifier;
            }

            public String getName() {
                return WoverRecipeProvider.this.title;
            }
        };
    }

    private static abstract class InnerRecipeProvider
    extends RecipeProvider {
        protected final FabricDataOutput output;

        public InnerRecipeProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super((PackOutput)output, registriesFuture);
            this.output = output;
        }

        public final void buildRecipes(RecipeOutput exporter) {
        }

        public abstract void buildRecipes(HolderLookup.Provider var1, RecipeOutput var2);

        public CompletableFuture<?> run(final CachedOutput writer, final HolderLookup.Provider wrapperLookup) {
            final HashSet generatedRecipes = Sets.newHashSet();
            final ArrayList list = new ArrayList();
            this.buildRecipes(wrapperLookup, new RecipeOutput(){

                public void accept(ResourceLocation recipeId, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
                    ResourceLocation identifier = this.getRecipeIdentifier(recipeId);
                    if (!generatedRecipes.add(identifier)) {
                        throw new IllegalStateException("Duplicate recipe " + String.valueOf(identifier));
                    }
                    RegistryOps registryOps = wrapperLookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
                    JsonObject recipeJson = ((JsonElement)Recipe.CODEC.encodeStart((DynamicOps)registryOps, recipe).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                    ResourceCondition[] conditions = FabricDataGenHelper.consumeConditions(recipe);
                    FabricDataGenHelper.addConditions((JsonObject)recipeJson, (ResourceCondition[])conditions);
                    list.add(DataProvider.saveStable((CachedOutput)writer, (JsonElement)recipeJson, (Path)recipePathProvider.json(identifier)));
                    if (advancement != null) {
                        JsonObject advancementJson = ((JsonElement)Advancement.CODEC.encodeStart((DynamicOps)registryOps, (Object)advancement.value()).getOrThrow(IllegalStateException::new)).getAsJsonObject();
                        FabricDataGenHelper.addConditions((JsonObject)advancementJson, (ResourceCondition[])conditions);
                        list.add(DataProvider.saveStable((CachedOutput)writer, (JsonElement)advancementJson, (Path)advancementPathProvider.json(this.getRecipeIdentifier(advancement.id()))));
                    }
                }

                public Advancement.Builder advancement() {
                    return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
                }
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        }

        protected ResourceLocation getRecipeIdentifier(ResourceLocation identifier) {
            return ResourceLocation.fromNamespaceAndPath((String)this.output.getModId(), (String)identifier.getPath());
        }
    }
}

