/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.complex.api.equipment.ToolSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolTier {
    public static final ToolSlot.PropertiesBuilder DIGGER_ITEM_PROPERTIES = (slot, tier) -> {
        ToolValues values = tier.getValues(slot);
        if (values == null) {
            throw new IllegalArgumentException("No values for slot " + String.valueOf((Object)slot) + " in tier " + String.valueOf(tier));
        }
        return new Item.Properties().attributes(DiggerItem.createAttributes((Tier)tier.toolTier, (float)values.attackDamage, (float)values.attackSpeed));
    };
    public static final ToolSlot.PropertiesBuilder SWORD_ITEM_PROPERTIES = (slot, tier) -> {
        ToolValues values = tier.getValues(slot);
        if (values == null) {
            throw new IllegalArgumentException("No values for slot " + String.valueOf((Object)slot) + " in tier " + String.valueOf(tier));
        }
        return new Item.Properties().attributes(SwordItem.createAttributes((Tier)tier.toolTier, (int)((int)values.attackDamage), (float)values.attackSpeed));
    };
    public final String name;
    public final Tier toolTier;
    public final TagKey<Block> blockTag;
    private final ToolValues[] toolValues;

    private ToolTier(String name, Tier toolTier, ToolValues[] toolValues, TagKey<Block> blockTag) {
        this.toolTier = toolTier;
        this.toolValues = toolValues;
        this.name = name;
        this.blockTag = blockTag;
    }

    @Nullable
    public ToolValues getValues(ToolSlot slot) {
        return this.toolValues[slot.slotIndex];
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public String toString() {
        return "ToolTier - " + this.name;
    }

    public ToolTier copyWithOffset(@NotNull String newName, @Nullable Tier newTier, ToolValues offset, @Nullable TagKey<Block> blockTag) {
        ToolValues[] newValues = new ToolValues[this.toolValues.length];
        for (int i = 0; i < this.toolValues.length; ++i) {
            if (this.toolValues[i] == null) continue;
            newValues[i] = this.toolValues[i].copyWithOffset(offset);
        }
        return new ToolTier(newName, newTier == null ? this.toolTier : newTier, newValues, blockTag);
    }

    public record ToolValues(float attackDamage, float attackSpeed, SmithingTemplateItem smithingTemplate) {
        public ToolValues(float attackDamage, float attackSpeed) {
            this(attackDamage, attackSpeed, null);
        }

        ToolValues copyWithOffset(ToolValues offset) {
            return new ToolValues(this.attackDamage + offset.attackDamage, this.attackSpeed + offset.attackSpeed, offset.smithingTemplate);
        }
    }

    public static class Builder {
        private Tier toolTier;
        private final ToolValues[] toolValues = new ToolValues[ToolSlot.values().length];
        private final String name;
        private TagKey<Block> blockTag;

        Builder(String name) {
            this.name = name;
        }

        public Builder blockTag(TagKey<Block> blockTag) {
            this.blockTag = blockTag;
            return this;
        }

        public Builder toolTier(Tier toolTier) {
            this.toolTier = toolTier;
            return this;
        }

        public Builder toolValues(ToolSlot slot, ToolValues toolValues) {
            this.toolValues[slot.slotIndex] = toolValues;
            return this;
        }

        public Builder toolValuesWithOffset(ToolTier source, ToolValues offset) {
            for (int i = 0; i < this.toolValues.length; ++i) {
                if (source.toolValues[i] == null) continue;
                this.toolValues[i] = source.toolValues[i].copyWithOffset(offset);
            }
            return this;
        }

        public ToolTier build() {
            return new ToolTier(this.name, this.toolTier, this.toolValues, this.blockTag);
        }
    }
}

