/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.SmithingTemplateItem;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorTier {
    public final Holder<ArmorMaterial> armorMaterial;
    private final ArmorValues[] armorValues;
    public final String name;

    private ArmorTier(String name, Holder<ArmorMaterial> armorMaterial, ArmorValues[] armorValues) {
        this.armorMaterial = armorMaterial;
        this.armorValues = armorValues;
        this.name = name;
    }

    @Nullable
    public ArmorValues getValues(ArmorSlot slot) {
        return this.armorValues[slot.slotIndex];
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean is(Holder<ArmorMaterial> mat) {
        return mat.unwrapKey().map(arg_0 -> this.armorMaterial.is(arg_0)).orElse(false);
    }

    public String toString() {
        return "ArmorTier - " + this.name;
    }

    public ArmorTier copyWithOffset(@NotNull String newName, @Nullable Holder<ArmorMaterial> newMaterial, ArmorValues offset) {
        ArmorValues[] newValues = new ArmorValues[this.armorValues.length];
        for (int i = 0; i < this.armorValues.length; ++i) {
            if (this.armorValues[i] == null) continue;
            newValues[i] = this.armorValues[i].copyWithOffset(offset);
        }
        return new ArmorTier(newName, newMaterial == null ? this.armorMaterial : newMaterial, newValues);
    }

    public record ArmorValues(int durability, SmithingTemplateItem smithingTemplate) {
        public ArmorValues(int durability) {
            this(durability, null);
        }

        public ArmorValues copyWithOffset(ArmorValues offset) {
            return new ArmorValues(this.durability + offset.durability, offset.smithingTemplate);
        }
    }

    public static class Builder {
        private Holder<ArmorMaterial> armorMaterial;
        private final ArmorValues[] armorValues = new ArmorValues[ArmorSlot.values().length];
        private final String name;

        public Builder(String name) {
            this.name = name;
        }

        public Builder armorMaterial(Holder<ArmorMaterial> armorMaterial) {
            this.armorMaterial = armorMaterial;
            return this;
        }

        public Builder allArmorValues(ArmorValues armorValues) {
            Arrays.fill(this.armorValues, armorValues);
            return this;
        }

        public Builder armorValues(ArmorSlot slot, ArmorValues armorValues) {
            this.armorValues[slot.slotIndex] = armorValues;
            return this;
        }

        public Builder armorValuesWithOffset(ArmorTier source, ArmorValues offset) {
            for (int i = 0; i < this.armorValues.length; ++i) {
                if (source.armorValues[i] == null) continue;
                this.armorValues[i] = source.armorValues[i].copyWithOffset(offset);
            }
            return this;
        }

        public ArmorTier build() {
            return new ArmorTier(this.name, this.armorMaterial, this.armorValues);
        }
    }
}

