/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.placed.modifiers;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.entrypoint.LibWoverFeature;
import org.betterx.wover.feature.api.placed.modifiers.All;
import org.betterx.wover.feature.api.placed.modifiers.Debug;
import org.betterx.wover.feature.api.placed.modifiers.EveryLayer;
import org.betterx.wover.feature.api.placed.modifiers.Extend;
import org.betterx.wover.feature.api.placed.modifiers.ExtendXYZ;
import org.betterx.wover.feature.api.placed.modifiers.FindInDirection;
import org.betterx.wover.feature.api.placed.modifiers.InBiome;
import org.betterx.wover.feature.api.placed.modifiers.Is;
import org.betterx.wover.feature.api.placed.modifiers.IsBasin;
import org.betterx.wover.feature.api.placed.modifiers.IsNextTo;
import org.betterx.wover.feature.api.placed.modifiers.Merge;
import org.betterx.wover.feature.api.placed.modifiers.NoiseFilter;
import org.betterx.wover.feature.api.placed.modifiers.Offset;
import org.betterx.wover.feature.api.placed.modifiers.OffsetProvider;
import org.betterx.wover.feature.api.placed.modifiers.Stencil;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.jetbrains.annotations.ApiStatus;

public class PlacementModifiersImpl {
    public static final PlacementModifierType<Stencil> STENCIL = PlacementModifiersImpl.registerLegacy("stencil", Stencil.CODEC);
    public static final PlacementModifierType<IsNextTo> IS_NEXT_TO = PlacementModifiersImpl.registerLegacy("is_next_to", IsNextTo.CODEC);
    public static final PlacementModifierType<NoiseFilter> NOISE_FILTER = PlacementModifiersImpl.registerLegacy("noise_filter", NoiseFilter.CODEC);
    public static final PlacementModifierType<Debug> DEBUG = PlacementModifiersImpl.registerLegacy("debug", Debug.CODEC);
    public static final PlacementModifierType<Merge> FOR_ALL = PlacementModifiersImpl.registerLegacy("for_all", Merge.CODEC);
    public static final PlacementModifierType<FindInDirection> SOLID_IN_DIR = PlacementModifiersImpl.registerLegacy("solid_in_dir", FindInDirection.CODEC);
    public static final PlacementModifierType<All> ALL = PlacementModifiersImpl.registerLegacy("all", All.CODEC);
    public static final PlacementModifierType<IsBasin> IS_BASIN = PlacementModifiersImpl.registerLegacy("is_basin", IsBasin.CODEC);
    public static final PlacementModifierType<Is> IS = PlacementModifiersImpl.registerLegacy("is", Is.CODEC);
    public static final PlacementModifierType<Offset> OFFSET = PlacementModifiersImpl.registerLegacy("offset", Offset.CODEC);
    public static final PlacementModifierType<OffsetProvider> OFFSET_PROVIDER = PlacementModifiersImpl.register("offset_provider", OffsetProvider.CODEC);
    public static final PlacementModifierType<Extend> EXTEND = PlacementModifiersImpl.registerLegacy("extend", Extend.CODEC);
    public static final PlacementModifierType<InBiome> IN_BIOME = PlacementModifiersImpl.registerLegacy("in_biome", InBiome.CODEC);
    public static final PlacementModifierType<ExtendXYZ> EXTEND_XZ = PlacementModifiersImpl.register("extend_xyz", ExtendXYZ.CODEC);
    public static final PlacementModifierType<EveryLayer> EVERY_LAYER = PlacementModifiersImpl.register("every_layer", EveryLayer.CODEC);

    private static <P extends PlacementModifier> PlacementModifierType<P> registerLegacy(String path, MapCodec<P> codec) {
        ResourceLocation id = LibWoverFeature.C.id(path);
        return PlacementModifiersImpl.register(id, codec, true);
    }

    private static <P extends PlacementModifier> PlacementModifierType<P> register(String path, MapCodec<P> codec) {
        ResourceLocation id = LibWoverFeature.C.id(path);
        return PlacementModifiersImpl.register(id, codec, false);
    }

    public static <P extends PlacementModifier> PlacementModifierType<P> register(ResourceLocation location, MapCodec<P> codec, boolean withLegacyBCLib) {
        PlacementModifierType res = (PlacementModifierType)Registry.register((Registry)BuiltInRegistries.PLACEMENT_MODIFIER_TYPE, (ResourceLocation)location, () -> codec);
        if (withLegacyBCLib && LegacyHelper.isLegacyEnabled()) {
            Registry.register((Registry)BuiltInRegistries.PLACEMENT_MODIFIER_TYPE, (ResourceLocation)LegacyHelper.BCLIB_CORE.convertNamespace(location), () -> codec);
        }
        return res;
    }

    @ApiStatus.Internal
    public static void ensureStaticInitialization() {
    }

    static {
        if (LegacyHelper.isLegacyEnabled()) {
            PlacementModifierType<EveryLayer> ON_EVERY_LAYER_LEGACY = PlacementModifiersImpl.register(LegacyHelper.BCLIB_CORE.id("on_every_layer"), EveryLayer.CODEC, false);
            PlacementModifierType<EveryLayer> placementModifierType = PlacementModifiersImpl.register(LegacyHelper.BCLIB_CORE.id("under_every_layer"), EveryLayer.CODEC_LEGACY_UNDER, false);
        }
    }
}

