/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.placed;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.block.api.predicate.BlockPredicates;
import org.betterx.wover.feature.api.configured.configurators.RandomPatch;
import org.betterx.wover.feature.api.placed.FeaturePlacementBuilder;
import org.betterx.wover.feature.api.placed.modifiers.All;
import org.betterx.wover.feature.api.placed.modifiers.Debug;
import org.betterx.wover.feature.api.placed.modifiers.EveryLayer;
import org.betterx.wover.feature.api.placed.modifiers.Extend;
import org.betterx.wover.feature.api.placed.modifiers.ExtendXYZ;
import org.betterx.wover.feature.api.placed.modifiers.FindInDirection;
import org.betterx.wover.feature.api.placed.modifiers.Is;
import org.betterx.wover.feature.api.placed.modifiers.IsBasin;
import org.betterx.wover.feature.api.placed.modifiers.IsNextTo;
import org.betterx.wover.feature.api.placed.modifiers.Merge;
import org.betterx.wover.feature.api.placed.modifiers.NoiseFilter;
import org.betterx.wover.feature.api.placed.modifiers.Offset;
import org.betterx.wover.feature.api.placed.modifiers.OffsetProvider;
import org.betterx.wover.feature.api.placed.modifiers.Stencil;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.betterx.wover.feature.impl.configured.InlineBuilderImpl;
import org.betterx.wover.feature.impl.configured.RandomPatchImpl;
import org.betterx.wover.math.api.valueproviders.Vec3iProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeaturePlacementBuilderImpl
implements FeaturePlacementBuilder {
    protected final List<PlacementModifier> modifications = new LinkedList<PlacementModifier>();
    @Nullable
    private final ResourceKey<PlacedFeature> key;
    @NotNull
    private final Holder<ConfiguredFeature<?, ?>> configuredFeatureHolder;
    @Nullable
    private final BootstrapContext<PlacedFeature> bootstrapContext;
    @Nullable
    private final ResourceKey<ConfiguredFeature<?, ?>> transitiveConfiguredFeatureKey;
    @Nullable
    private final BiFunction<ResourceKey<ConfiguredFeature<?, ?>>, ResourceKey<PlacedFeature>, RandomPatchImpl> randomPatchBuilder;

    public FeaturePlacementBuilderImpl(@Nullable BootstrapContext<PlacedFeature> bootstrapContext, @Nullable ResourceKey<PlacedFeature> key, @NotNull Holder<ConfiguredFeature<?, ?>> configuredFeatureHolder) {
        this(bootstrapContext, key, configuredFeatureHolder, null, null);
    }

    public FeaturePlacementBuilderImpl(@Nullable BootstrapContext<PlacedFeature> bootstrapContext, @Nullable ResourceKey<PlacedFeature> key, @NotNull Holder<ConfiguredFeature<?, ?>> configuredFeatureHolder, @Nullable ResourceKey<ConfiguredFeature<?, ?>> transitiveConfiguredFeatureKey, @Nullable BiFunction<ResourceKey<ConfiguredFeature<?, ?>>, ResourceKey<PlacedFeature>, RandomPatchImpl> randomPatchBuilder) {
        this.bootstrapContext = bootstrapContext;
        this.key = key;
        this.configuredFeatureHolder = configuredFeatureHolder;
        this.transitiveConfiguredFeatureKey = transitiveConfiguredFeatureKey;
        this.randomPatchBuilder = randomPatchBuilder;
    }

    @ApiStatus.Internal
    public static FeaturePlacementBuilderImpl withTransitive(FeatureConfiguratorImpl<?, ?> configuredFeatureBuilder, BiFunction<ResourceKey<ConfiguredFeature<?, ?>>, ResourceKey<PlacedFeature>, RandomPatchImpl> randomPatchBuilder) {
        return new FeaturePlacementBuilderImpl(configuredFeatureBuilder.getTransitiveBootstrapContext(), configuredFeatureBuilder.getTransitiveFeatureKey(), configuredFeatureBuilder.directHolder(), configuredFeatureBuilder.key, randomPatchBuilder);
    }

    @Override
    public FeaturePlacementBuilderImpl count(int count) {
        return this.modifier(new PlacementModifier[]{CountPlacement.of((int)count)});
    }

    @Override
    public FeaturePlacementBuilderImpl countMax(int count) {
        return this.modifier(new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)count))});
    }

    @Override
    public FeaturePlacementBuilderImpl countRange(int min, int max) {
        return this.modifier(new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)min, (int)max))});
    }

    @Override
    public FeaturePlacementBuilderImpl all() {
        return this.modifier(All.simple());
    }

    @Override
    public FeaturePlacementBuilderImpl stencil() {
        return this.modifier(Stencil.all());
    }

    @Override
    public FeaturePlacementBuilderImpl stencilOneIn4() {
        return this.modifier(Stencil.oneIn4());
    }

    @Override
    public FeaturePlacementBuilderImpl onEveryLayer(int repetitions) {
        return this.modifier(new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)repetitions)});
    }

    @Override
    public FeaturePlacementBuilderImpl onEveryLayerMax(int count) {
        return this.modifier(new PlacementModifier[]{CountOnEveryLayerPlacement.of((IntProvider)UniformInt.of((int)0, (int)count))});
    }

    @Override
    public FeaturePlacementBuilderImpl onEveryLayer() {
        return this.modifier(EveryLayer.on());
    }

    @Override
    public FeaturePlacementBuilderImpl onEveryLayerMin4() {
        return this.modifier(EveryLayer.onTopMin4());
    }

    @Override
    public FeaturePlacementBuilderImpl underEveryLayer() {
        return this.modifier(EveryLayer.underneath());
    }

    @Override
    public FeaturePlacementBuilderImpl underEveryLayerMin4() {
        return this.modifier(EveryLayer.underneathMin4());
    }

    @Override
    public FeaturePlacementBuilderImpl onceEvery(int n) {
        return this.modifier(new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)n)});
    }

    @Override
    public FeaturePlacementBuilderImpl onlyInBiome() {
        return this.modifier(new PlacementModifier[]{BiomeFilter.biome()});
    }

    @Override
    public FeaturePlacementBuilderImpl noiseIn(double min, double max, float scaleXZ, float scaleY) {
        return this.modifier(new PlacementModifier[]{new NoiseFilter((ResourceKey<NormalNoise.NoiseParameters>)Noises.GRAVEL, min, max, scaleXZ, scaleY)});
    }

    @Override
    public FeaturePlacementBuilderImpl noiseAbove(double value, float scaleXZ, float scaleY) {
        return this.modifier(new PlacementModifier[]{new NoiseFilter((ResourceKey<NormalNoise.NoiseParameters>)Noises.GRAVEL, value, Double.MAX_VALUE, scaleXZ, scaleY)});
    }

    @Override
    public FeaturePlacementBuilderImpl noiseBelow(double value, float scaleXZ, float scaleY) {
        return this.modifier(new PlacementModifier[]{new NoiseFilter((ResourceKey<NormalNoise.NoiseParameters>)Noises.GRAVEL, -1.7976931348623157E308, value, scaleXZ, scaleY)});
    }

    @Override
    public FeaturePlacementBuilderImpl squarePlacement() {
        return this.modifier(new PlacementModifier[]{InSquarePlacement.spread()});
    }

    @Override
    public FeaturePlacementBuilderImpl randomHeight10FromFloorCeil() {
        return this.modifier(PlacementUtils.RANGE_10_10);
    }

    @Override
    public FeaturePlacementBuilderImpl randomHeight4FromFloorCeil() {
        return this.modifier(PlacementUtils.RANGE_4_4);
    }

    @Override
    public FeaturePlacementBuilderImpl randomHeight8FromFloorCeil() {
        return this.modifier(PlacementUtils.RANGE_8_8);
    }

    @Override
    public FeaturePlacementBuilderImpl randomHeightFromFloorToMaxTerrain() {
        return this.modifier(PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT);
    }

    @Override
    public FeaturePlacementBuilderImpl randomHeight() {
        return this.modifier(PlacementUtils.FULL_RANGE);
    }

    @Override
    public FeaturePlacementBuilderImpl spreadHorizontal(IntProvider p) {
        return this.modifier(new PlacementModifier[]{RandomOffsetPlacement.horizontal((IntProvider)p)});
    }

    @Override
    public FeaturePlacementBuilderImpl spreadVertical(IntProvider p) {
        return this.modifier(new PlacementModifier[]{RandomOffsetPlacement.horizontal((IntProvider)p)});
    }

    @Override
    public FeaturePlacementBuilderImpl spread(IntProvider horizontal, IntProvider vertical) {
        return this.modifier(new PlacementModifier[]{RandomOffsetPlacement.of((IntProvider)horizontal, (IntProvider)vertical)});
    }

    @Override
    public FeaturePlacementBuilderImpl offset(Direction dir) {
        return this.modifier(Offset.inDirection(dir));
    }

    @Override
    public FeaturePlacementBuilderImpl offset(Vec3i dir) {
        return this.modifier(new Offset(dir));
    }

    @Override
    public FeaturePlacementBuilderImpl offset(int x, int y, int z) {
        return this.offset(new Vec3i(x, y, z));
    }

    @Override
    public FeaturePlacementBuilderImpl offset(IntProvider x, IntProvider y, IntProvider z) {
        return this.modifier(new OffsetProvider(new Vec3iProvider(x, y, z)));
    }

    @Override
    public FeaturePlacementBuilderImpl noiseBasedCount(float noiseLevel, int belowNoiseCount, int aboveNoiseCount) {
        return this.modifier(new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)noiseLevel, (int)belowNoiseCount, (int)aboveNoiseCount)});
    }

    @Override
    public FeaturePlacementBuilderImpl extendDown(int min, int max) {
        return this.modifier(new Extend(Direction.DOWN, (IntProvider)UniformInt.of((int)min, (int)max)));
    }

    @Override
    public FeaturePlacementBuilderImpl inBasinOf(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{IsBasin.simple(BlockPredicate.anyOf((BlockPredicate[])predicates))});
    }

    @Override
    public FeaturePlacementBuilderImpl inOpenBasinOf(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{IsBasin.openTop(BlockPredicate.anyOf((BlockPredicate[])predicates))});
    }

    @Override
    public FeaturePlacementBuilderImpl is(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{new Is(BlockPredicate.anyOf((BlockPredicate[])predicates), Optional.empty())});
    }

    @Override
    public FeaturePlacementBuilderImpl isAbove(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{new Is(BlockPredicate.anyOf((BlockPredicate[])predicates), Optional.of(Direction.DOWN.getNormal()))});
    }

    @Override
    public FeaturePlacementBuilderImpl isUnder(BlockPredicate ... predicates) {
        return this.modifier(new PlacementModifier[]{new Is(BlockPredicate.anyOf((BlockPredicate[])predicates), Optional.of(Direction.UP.getNormal()))});
    }

    @Override
    public FeaturePlacementBuilderImpl findSolidFloor(int distance) {
        return this.modifier(FindInDirection.down(distance));
    }

    @Override
    public FeaturePlacementBuilderImpl findSolidCeil(int distance) {
        return this.modifier(FindInDirection.up(distance));
    }

    @Override
    public FeaturePlacementBuilderImpl findSolidSurface(Direction dir, int distance) {
        return this.modifier(new FindInDirection(dir, distance, 0, BlockPredicates.ONLY_GROUND));
    }

    @Override
    public FeaturePlacementBuilderImpl findSolidSurface(List<Direction> dir, int distance, boolean randomSelect) {
        return this.modifier(new FindInDirection(dir, distance, randomSelect, 0, BlockPredicates.ONLY_GROUND));
    }

    @Override
    public FeaturePlacementBuilderImpl onWalls(int distance, int depth) {
        return this.modifier(new FindInDirection(BlockHelper.HORIZONTAL, distance, false, depth, BlockPredicates.ONLY_GROUND));
    }

    @Override
    public FeaturePlacementBuilderImpl onHeightmap(Heightmap.Types types) {
        return this.modifier(new PlacementModifier[]{HeightmapPlacement.onHeightmap((Heightmap.Types)types)});
    }

    @Override
    public FeaturePlacementBuilder projectToSurface() {
        return this.heightmap().offset(0, -1, 0);
    }

    @Override
    public FeaturePlacementBuilderImpl heightmap() {
        return this.modifier(PlacementUtils.HEIGHTMAP);
    }

    @Override
    public FeaturePlacementBuilderImpl heightmapTopSolid() {
        return this.modifier(PlacementUtils.HEIGHTMAP_TOP_SOLID);
    }

    @Override
    public FeaturePlacementBuilderImpl heightmapWorldSurface() {
        return this.modifier(PlacementUtils.HEIGHTMAP_WORLD_SURFACE);
    }

    @Override
    public FeaturePlacementBuilder heightmapOceanFloor() {
        return this.modifier(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR);
    }

    @Override
    public FeaturePlacementBuilderImpl extendXYZ(int xzSpread, float centerDensity, float borderDensity, int height, boolean square, ExtendXYZ.HeightPropagation propagation) {
        return this.modifier(new ExtendXYZ((IntProvider)ConstantInt.of((int)xzSpread), (FloatProvider)ConstantFloat.of((float)centerDensity), (FloatProvider)ConstantFloat.of((float)borderDensity), square, (FloatProvider)ConstantFloat.of((float)((float)Math.abs(height) / (float)xzSpread)), propagation));
    }

    @Override
    public FeaturePlacementBuilder extendXYZ(IntProvider xzSpread, FloatProvider centerDensity, FloatProvider borderDensity, FloatProvider heightScale, boolean square, ExtendXYZ.HeightPropagation propagation) {
        return this.modifier(new ExtendXYZ(xzSpread, centerDensity, borderDensity, square, heightScale, propagation));
    }

    @Override
    public FeaturePlacementBuilderImpl extendXZ(int xzSpread, float centerDensity, float borderDensity, boolean square) {
        return this.modifier(new ExtendXYZ((IntProvider)ConstantInt.of((int)xzSpread), (FloatProvider)ConstantFloat.of((float)centerDensity), (FloatProvider)ConstantFloat.of((float)borderDensity), square));
    }

    @Override
    public FeaturePlacementBuilder extendXZ(IntProvider xzSpread, FloatProvider centerDensity, FloatProvider borderDensity, boolean square) {
        return this.modifier(new ExtendXYZ(xzSpread, centerDensity, borderDensity, square));
    }

    @Override
    public FeaturePlacementBuilderImpl extendZigZagXZ(int xzSpread) {
        UniformInt xz = UniformInt.of((int)0, (int)xzSpread);
        return this.modifier(new Merge(List.of(new Extend(Direction.NORTH, (IntProvider)xz), new Extend(Direction.SOUTH, (IntProvider)xz), new Extend(Direction.EAST, (IntProvider)xz), new Extend(Direction.WEST, (IntProvider)xz))), new Merge(List.of(new Extend(Direction.EAST, (IntProvider)xz), new Extend(Direction.WEST, (IntProvider)xz), new Extend(Direction.NORTH, (IntProvider)xz), new Extend(Direction.SOUTH, (IntProvider)xz))));
    }

    @Override
    public FeaturePlacementBuilderImpl extendZigZagXYZ(int xzSpread, int ySpread) {
        UniformInt xz = UniformInt.of((int)0, (int)xzSpread);
        return this.extendZigZagXZ(xzSpread).extendDown(1, ySpread);
    }

    @Override
    public FeaturePlacementBuilderImpl isEmpty() {
        return this.modifier(new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE)});
    }

    @Override
    public FeaturePlacementBuilderImpl is(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)predicate)});
    }

    @Override
    public FeaturePlacementBuilderImpl isNextTo(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{IsNextTo.simple(predicate)});
    }

    @Override
    public FeaturePlacementBuilderImpl belowIsNextTo(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{IsNextTo.offset(predicate, Direction.DOWN.getNormal())});
    }

    @Override
    public FeaturePlacementBuilderImpl isNextTo(BlockPredicate predicate, Vec3i offset) {
        return this.modifier(new PlacementModifier[]{IsNextTo.offset(predicate, offset)});
    }

    @Override
    public FeaturePlacementBuilderImpl isOn(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{Is.below(predicate)});
    }

    @Override
    public FeaturePlacementBuilderImpl isEmptyAndOn(BlockPredicate predicate) {
        return this.isEmpty().isOn(predicate);
    }

    @Override
    public FeaturePlacementBuilderImpl isEmptyAndOnNylium() {
        return this.isEmptyAndOn(BlockPredicates.ONLY_NYLIUM);
    }

    @Override
    public FeaturePlacementBuilderImpl isEmptyAndOnNetherGround() {
        return this.isEmptyAndOn(BlockPredicates.ONLY_NETHER_GROUND);
    }

    @Override
    public FeaturePlacementBuilderImpl isUnder(BlockPredicate predicate) {
        return this.modifier(new PlacementModifier[]{Is.above(predicate)});
    }

    @Override
    public FeaturePlacementBuilderImpl isEmptyAndUnder(BlockPredicate predicate) {
        return this.isEmpty().isUnder(predicate);
    }

    @Override
    public FeaturePlacementBuilderImpl isEmptyAndUnderNylium() {
        return this.isEmptyAndUnder(BlockPredicates.ONLY_NYLIUM);
    }

    @Override
    public FeaturePlacementBuilderImpl isEmptyAndUnderNetherGround() {
        return this.isEmptyAndUnder(BlockPredicates.ONLY_NETHER_GROUND);
    }

    @Override
    public FeaturePlacementBuilderImpl isFullShape() {
        return this.isEmptyAndUnder(BlockPredicates.IS_FULL_BLOCK);
    }

    @Override
    public FeaturePlacementBuilderImpl vanillaNetherGround(int countPerLayer) {
        return this.randomHeight4FromFloorCeil().onlyInBiome().onEveryLayer(countPerLayer).onlyInBiome();
    }

    @Override
    public FeaturePlacementBuilderImpl betterNetherGround(int countPerLayer) {
        return this.randomHeight4FromFloorCeil().count(countPerLayer).squarePlacement().onEveryLayerMin4().onlyInBiome();
    }

    @Override
    public FeaturePlacementBuilderImpl betterNetherCeiling(int countPerLayer) {
        return this.randomHeight4FromFloorCeil().count(countPerLayer).squarePlacement().onlyInBiome().underEveryLayerMin4().onlyInBiome();
    }

    @Override
    public FeaturePlacementBuilderImpl betterNetherOnWall(int countPerLayer) {
        return this.count(countPerLayer).squarePlacement().randomHeight4FromFloorCeil().onlyInBiome().onWalls(16, 0);
    }

    @Override
    public FeaturePlacementBuilderImpl betterNetherInWall(int countPerLayer) {
        return this.count(countPerLayer).squarePlacement().randomHeight4FromFloorCeil().onlyInBiome().onWalls(16, 1);
    }

    @Override
    public FeaturePlacementBuilderImpl modifier(PlacementModifier ... modifiers) {
        for (PlacementModifier m : modifiers) {
            this.modifications.add(m);
        }
        return this;
    }

    @Override
    public FeaturePlacementBuilderImpl modifier(List<PlacementModifier> modifiers) {
        this.modifications.addAll(modifiers);
        return this;
    }

    @Override
    public FeaturePlacementBuilderImpl debug(String caption) {
        return this.modifier(new Debug(caption));
    }

    @Override
    public RandomPatch inRandomPatch() {
        RandomPatch randomPatch = this.randomPatchBuilder != null ? (RandomPatch)this.randomPatchBuilder.apply(this.transitiveConfiguredFeatureKey, this.key) : new InlineBuilderImpl(this.bootstrapContext, this.key).randomPatch();
        return randomPatch.featureToPlace(this.directHolder());
    }

    @Override
    public Holder<PlacedFeature> register() {
        if (this.key == null) {
            throw new IllegalStateException("A ResourceKey for a Feature can not be null if it should be registered!");
        }
        if (this.bootstrapContext == null) {
            throw new IllegalStateException("A BootstrapContext for a Feature can not be null if it should be registered! (" + String.valueOf(this.key.location()) + ")");
        }
        PlacedFeature feature = this.build();
        return this.bootstrapContext.register(this.key, (Object)feature);
    }

    @Override
    public Holder<PlacedFeature> directHolder() {
        return Holder.direct((Object)this.build());
    }

    @NotNull
    public PlacedFeature build() {
        return new PlacedFeature(this.configuredFeatureHolder, this.modifications);
    }
}

