/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.wover.feature.api.Features;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.WithTemplates;
import org.betterx.wover.feature.api.features.TemplateFeature;
import org.betterx.wover.feature.api.features.config.TemplateFeatureConfig;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.betterx.wover.feature.impl.features.FeatureTemplateImpl;
import org.betterx.wover.util.RandomizedWeightedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WithTemplatesImpl
extends FeatureConfiguratorImpl<TemplateFeatureConfig, TemplateFeature<TemplateFeatureConfig>>
implements WithTemplates {
    private final RandomizedWeightedList<TemplateFeatureConfig.FeatureTemplate> templates = new RandomizedWeightedList();

    WithTemplatesImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public WithTemplates add(ResourceLocation location) {
        return this.add(location, 0, 1.0f);
    }

    @Override
    public WithTemplates add(ResourceLocation location, float weight) {
        return this.add(location, 0, weight);
    }

    @Override
    public WithTemplates add(ResourceLocation location, int offsetY, float weight) {
        this.templates.add((Object)FeatureTemplateImpl.createTemplate(location, offsetY), (double)weight);
        return this;
    }

    @Override
    @NotNull
    public TemplateFeatureConfig createConfiguration() {
        if (this.templates.isEmpty()) {
            this.throwStateError("Template Feature Config must have at least one template!");
        }
        return TemplateFeatureConfig.of(this.templates);
    }

    @Override
    @NotNull
    protected TemplateFeature<TemplateFeatureConfig> getFeature() {
        return (TemplateFeature)Features.TEMPLATE;
    }

    public static class Key
    extends ConfiguredFeatureKey<WithTemplates> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public WithTemplates bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new WithTemplatesImpl(ctx, this.key);
        }
    }
}

