/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.RandomPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureManager;
import org.betterx.wover.feature.api.configured.configurators.WeightedBlockPatch;
import org.betterx.wover.feature.api.placed.FeaturePlacementBuilder;
import org.betterx.wover.feature.impl.configured.WeightedBaseBlockImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeightedBlockPatchImpl
extends WeightedBaseBlockImpl<RandomPatchConfiguration, RandomPatchFeature, WeightedBlockPatch>
implements WeightedBlockPatch {
    private BlockPredicate groundType = null;
    private boolean isEmpty = true;
    private int tries = 96;
    private int xzSpread = 7;
    private int ySpread = 3;

    WeightedBlockPatchImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public WeightedBlockPatch isEmpty() {
        return this.isEmpty(true);
    }

    @Override
    public WeightedBlockPatch isEmpty(boolean value) {
        this.isEmpty = value;
        return this;
    }

    @Override
    public WeightedBlockPatch isOn(BlockPredicate predicate) {
        this.groundType = predicate;
        return this;
    }

    @Override
    public WeightedBlockPatch isEmptyAndOn(BlockPredicate predicate) {
        return this.isEmpty().isOn(predicate);
    }

    @Override
    public WeightedBlockPatch likeDefaultNetherVegetation() {
        return this.likeDefaultNetherVegetation(8, 4);
    }

    @Override
    public WeightedBlockPatch likeDefaultNetherVegetation(int xzSpread, int ySpread) {
        this.xzSpread = xzSpread;
        this.ySpread = ySpread;
        this.tries = xzSpread * xzSpread;
        return this;
    }

    @Override
    public WeightedBlockPatch tries(int v) {
        this.tries = v;
        return this;
    }

    @Override
    public WeightedBlockPatch spreadXZ(int v) {
        this.xzSpread = v;
        return this;
    }

    @Override
    public WeightedBlockPatch spreadY(int v) {
        this.ySpread = v;
        return this;
    }

    @Override
    @NotNull
    public RandomPatchConfiguration createConfiguration() {
        FeaturePlacementBuilder blockFeature = ConfiguredFeatureManager.INLINE_BUILDER.simple().block((BlockStateProvider)new WeightedStateProvider(this.stateBuilder.build())).inlinePlace();
        if (this.isEmpty) {
            blockFeature.isEmpty();
        }
        if (this.groundType != null) {
            blockFeature.isOn(this.groundType);
        }
        return new RandomPatchConfiguration(this.tries, this.xzSpread, this.ySpread, blockFeature.directHolder());
    }

    @Override
    @NotNull
    protected RandomPatchFeature getFeature() {
        return (RandomPatchFeature)Feature.RANDOM_PATCH;
    }

    public static class KeyBonemeal
    extends ConfiguredFeatureKey<WeightedBlockPatch> {
        public KeyBonemeal(ResourceLocation id) {
            super(id);
        }

        @Override
        public WeightedBlockPatch bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return (WeightedBlockPatch)new WeightedBlockPatchImpl(ctx, this.key).likeDefaultBonemeal();
        }
    }

    public static class Key
    extends ConfiguredFeatureKey<WeightedBlockPatch> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public WeightedBlockPatch bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new WeightedBlockPatchImpl(ctx, this.key);
        }
    }
}

