/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.Collection;
import java.util.Set;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.feature.api.configured.configurators.BaseWeightedBlock;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.Nullable;

public abstract class WeightedBaseBlockImpl<FC extends FeatureConfiguration, F extends Feature<FC>, W extends BaseWeightedBlock<FC, F, W>>
extends FeatureConfiguratorImpl<FC, F>
implements BaseWeightedBlock<FC, F, W> {
    SimpleWeightedRandomList.Builder<BlockState> stateBuilder = SimpleWeightedRandomList.builder();

    WeightedBaseBlockImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public W add(Block block, int weight) {
        return this.add(block.defaultBlockState(), weight);
    }

    @Override
    public W add(BlockState state, int weight) {
        this.stateBuilder.add((Object)state, weight);
        return (W)this;
    }

    @Override
    public W addAllStates(Block block, int weight) {
        Set states = BlockHelper.getPossibleStates((Block)block);
        states.forEach(s -> this.add(block.defaultBlockState(), Math.max(1, weight / states.size())));
        return (W)this;
    }

    @Override
    public W addAllStatesFor(IntegerProperty prop, Block block, int weight) {
        Collection values = prop.getPossibleValues();
        values.forEach(s -> this.add((BlockState)block.defaultBlockState().setValue((Property)prop, (Comparable)s), Math.max(1, weight / values.size())));
        return (W)this;
    }
}

