/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.Collection;
import java.util.Set;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.NetherForestVegetationFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.NetherForrestVegetation;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetherForrestVegetationImpl
extends FeatureConfiguratorImpl<NetherForestVegetationConfig, NetherForestVegetationFeature>
implements NetherForrestVegetation {
    private SimpleWeightedRandomList.Builder<BlockState> blocks;
    private WeightedStateProvider stateProvider;
    private int spreadWidth = 8;
    private int spreadHeight = 4;

    NetherForrestVegetationImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public NetherForrestVegetation spreadWidth(int width) {
        this.spreadWidth = width;
        return this;
    }

    @Override
    public NetherForrestVegetation spreadHeight(int height) {
        this.spreadHeight = height;
        return this;
    }

    @Override
    public NetherForrestVegetation addAllStates(Block block, int weight) {
        Set states = BlockHelper.getPossibleStates((Block)block);
        states.forEach(s -> this.add(block.defaultBlockState(), Math.max(1, weight / states.size())));
        return this;
    }

    @Override
    public NetherForrestVegetation addAllStatesFor(IntegerProperty prop, Block block, int weight) {
        Collection values = prop.getPossibleValues();
        values.forEach(s -> this.add((BlockState)block.defaultBlockState().setValue((Property)prop, (Comparable)s), Math.max(1, weight / values.size())));
        return this;
    }

    @Override
    public NetherForrestVegetation add(Block block, int weight) {
        return this.add(block.defaultBlockState(), weight);
    }

    @Override
    public NetherForrestVegetation add(BlockState state, int weight) {
        if (this.stateProvider != null) {
            throw new IllegalStateException("You can not add new state once a WeightedStateProvider was built. (" + String.valueOf(state) + ", " + weight + ")");
        }
        if (this.blocks == null) {
            this.blocks = SimpleWeightedRandomList.builder();
        }
        this.blocks.add((Object)state, weight);
        return this;
    }

    @Override
    public NetherForrestVegetation provider(WeightedStateProvider provider) {
        if (this.blocks != null) {
            this.throwStateError("You can not set a WeightedStateProvider after states were added manually.");
        }
        this.stateProvider = provider;
        return this;
    }

    @Override
    public NetherForestVegetationConfig createConfiguration() {
        if (this.stateProvider == null && this.blocks == null) {
            this.throwStateError("NetherForestVegetationConfig needs at least one BlockState");
        }
        if (this.stateProvider == null) {
            this.stateProvider = new WeightedStateProvider(this.blocks.build());
        }
        return new NetherForestVegetationConfig((BlockStateProvider)this.stateProvider, this.spreadWidth, this.spreadHeight);
    }

    @Override
    @NotNull
    protected NetherForestVegetationFeature getFeature() {
        return (NetherForestVegetationFeature)Feature.NETHER_FOREST_VEGETATION;
    }

    public static class KeyBonemeal
    extends ConfiguredFeatureKey<NetherForrestVegetation> {
        public KeyBonemeal(ResourceLocation id) {
            super(id);
        }

        @Override
        public NetherForrestVegetation bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new NetherForrestVegetationImpl(ctx, this.key).spreadHeight(1).spreadWidth(3);
        }
    }

    public static class Key
    extends ConfiguredFeatureKey<NetherForrestVegetation> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public NetherForrestVegetation bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new NetherForrestVegetationImpl(ctx, this.key);
        }
    }
}

