/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.feature.impl.configured.RandomPatchImpl;
import org.betterx.wover.feature.impl.placed.FeaturePlacementBuilderImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FeatureConfiguratorImpl<FC extends FeatureConfiguration, F extends Feature<FC>> {
    public static final EventImpl<OnBootstrapRegistry<ConfiguredFeature<?, ?>>> BOOTSTRAP_CONFIGURED_FEATURES = new EventImpl("BOOTSTRAP_CONFIGURED_FEATURES");
    private static boolean didInit = false;
    @Nullable
    public final ResourceKey<ConfiguredFeature<?, ?>> key;
    @Nullable
    protected final BootstrapContext<ConfiguredFeature<?, ?>> bootstrapContext;
    private ResourceKey<PlacedFeature> transitiveFeatureKey;
    private BootstrapContext<PlacedFeature> transitiveBootstrapContext;

    @ApiStatus.Internal
    public static void initialize() {
        if (didInit) {
            return;
        }
        didInit = true;
        DatapackRegistryBuilder.addBootstrap((ResourceKey)Registries.CONFIGURED_FEATURE, FeatureConfiguratorImpl::onBootstrap);
    }

    private static void onBootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        BOOTSTRAP_CONFIGURED_FEATURES.emit(c -> c.bootstrap(context));
    }

    @NotNull
    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(@NotNull ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)id);
    }

    @Nullable
    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> getHolder(@Nullable HolderGetter<ConfiguredFeature<?, ?>> getter, @NotNull ResourceKey<ConfiguredFeature<?, ?>> key) {
        if (getter == null) {
            return null;
        }
        Optional h = getter.get(key);
        return h.orElse(null);
    }

    FeatureConfiguratorImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        this.key = key;
        this.bootstrapContext = ctx;
    }

    void setTransitive(BootstrapContext<PlacedFeature> ctx, ResourceKey<PlacedFeature> key) {
        this.transitiveBootstrapContext = ctx;
        this.transitiveFeatureKey = key;
    }

    @ApiStatus.Internal
    public ResourceKey<PlacedFeature> getTransitiveFeatureKey() {
        return this.transitiveFeatureKey;
    }

    @ApiStatus.Internal
    public BootstrapContext<PlacedFeature> getTransitiveBootstrapContext() {
        return this.transitiveBootstrapContext;
    }

    @NotNull
    protected abstract FC createConfiguration();

    @NotNull
    protected abstract F getFeature();

    public Holder<ConfiguredFeature<?, ?>> register() {
        if (this.key == null) {
            throw new IllegalStateException("A ResourceKey can not be null if a feature should be registered!");
        }
        if (this.bootstrapContext == null) {
            this.throwStateError("Can not register a feature without a bootstrap context!");
        }
        ConfiguredFeature<FC, F> cFeature = this.build();
        return this.bootstrapContext.register(this.key, cFeature);
    }

    public Holder<ConfiguredFeature<?, ?>> directHolder() {
        return Holder.direct(this.build());
    }

    public FeaturePlacementBuilderImpl inlinePlace() {
        return FeaturePlacementBuilderImpl.withTransitive(this, (cfg, plc) -> {
            RandomPatchImpl res = new RandomPatchImpl(this.bootstrapContext, (ResourceKey<ConfiguredFeature<?, ?>>)cfg);
            res.setTransitive(this.transitiveBootstrapContext, (ResourceKey<PlacedFeature>)plc);
            return res;
        });
    }

    @NotNull
    private ConfiguredFeature<FC, F> build() {
        FC config = this.createConfiguration();
        if (config == null) {
            throw new IllegalStateException("Feature configuration for " + String.valueOf(this.key.location()) + " can not be null!");
        }
        return new ConfiguredFeature(this.getFeature(), config);
    }

    void throwStateError(String message) {
        throw new IllegalStateException(message + (String)(this.key == null ? "" : "(" + String.valueOf(this.key.location()) + ")"));
    }
}

