/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.feature.api.Features;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.FacingBlock;
import org.betterx.wover.feature.api.features.PlaceBlockFeature;
import org.betterx.wover.feature.api.features.config.PlaceFacingBlockConfig;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacingBlockImpl
extends FeatureConfiguratorImpl<PlaceFacingBlockConfig, PlaceBlockFeature<PlaceFacingBlockConfig>>
implements FacingBlock {
    private final SimpleWeightedRandomList.Builder<BlockState> stateBuilder = SimpleWeightedRandomList.builder();
    BlockState firstState;
    private int count = 0;
    private List<Direction> directions = BlockHelper.HORIZONTAL;

    FacingBlockImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public FacingBlock allHorizontal() {
        this.directions = BlockHelper.HORIZONTAL;
        return this;
    }

    @Override
    public FacingBlock allVertical() {
        this.directions = BlockHelper.VERTICAL;
        return this;
    }

    @Override
    public FacingBlock allDirections() {
        this.directions = BlockHelper.ALL;
        return this;
    }

    @Override
    public FacingBlock add(Block block) {
        return this.add(block, 1);
    }

    @Override
    public FacingBlock add(BlockState state) {
        return this.add(state, 1);
    }

    @Override
    public FacingBlock add(Block block, int weight) {
        return this.add(block.defaultBlockState(), weight);
    }

    @Override
    public FacingBlock add(BlockState state, int weight) {
        if (this.firstState == null) {
            this.firstState = state;
        }
        ++this.count;
        this.stateBuilder.add((Object)state, weight);
        return this;
    }

    @Override
    public FacingBlock addAllStates(Block block, int weight) {
        Set states = BlockHelper.getPossibleStates((Block)block);
        states.forEach(s -> this.add((BlockState)s, Math.max(1, weight / states.size())));
        return this;
    }

    @Override
    public FacingBlock addAllStatesFor(IntegerProperty prop, Block block, int weight) {
        Collection values = prop.getPossibleValues();
        values.forEach(s -> this.add((BlockState)block.defaultBlockState().setValue((Property)prop, (Comparable)s), Math.max(1, weight / values.size())));
        return this;
    }

    @Override
    @NotNull
    public PlaceFacingBlockConfig createConfiguration() {
        SimpleStateProvider provider = null;
        if (this.count == 1) {
            provider = SimpleStateProvider.simple((BlockState)this.firstState);
        } else {
            SimpleWeightedRandomList list = this.stateBuilder.build();
            if (!list.isEmpty()) {
                provider = new WeightedStateProvider(list);
            }
        }
        if (provider == null) {
            throw new IllegalStateException("Facing Blocks need a State Provider.");
        }
        return new PlaceFacingBlockConfig((BlockStateProvider)provider, this.directions);
    }

    @Override
    @NotNull
    protected PlaceBlockFeature<PlaceFacingBlockConfig> getFeature() {
        return (PlaceBlockFeature)Features.PLACE_BLOCK;
    }

    public static class Key
    extends ConfiguredFeatureKey<FacingBlock> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public FacingBlock bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new FacingBlockImpl(ctx, this.key);
        }
    }
}

