/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.RandomSelectorFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.AsRandomSelect;
import org.betterx.wover.feature.api.placed.PlacedFeatureKey;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsRandomSelectImpl
extends FeatureConfiguratorImpl<RandomFeatureConfiguration, RandomSelectorFeature>
implements AsRandomSelect {
    private final List<WeightedPlacedFeature> features = new LinkedList<WeightedPlacedFeature>();
    private Holder<PlacedFeature> defaultFeature;

    AsRandomSelectImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public AsRandomSelect add(PlacedFeatureKey feature, float weight) {
        return this.add(feature.getHolder(this.bootstrapContext), weight);
    }

    @Override
    public AsRandomSelect add(Holder<PlacedFeature> feature, float weight) {
        this.features.add(new WeightedPlacedFeature(feature, weight));
        return this;
    }

    @Override
    public AsRandomSelect defaultFeature(PlacedFeatureKey feature) {
        return this.defaultFeature(feature.getHolder(this.bootstrapContext));
    }

    @Override
    public AsRandomSelect defaultFeature(Holder<PlacedFeature> feature) {
        this.defaultFeature = feature;
        return this;
    }

    @Override
    @NotNull
    public RandomFeatureConfiguration createConfiguration() {
        return new RandomFeatureConfiguration(this.features, this.defaultFeature);
    }

    @Override
    @NotNull
    protected RandomSelectorFeature getFeature() {
        return (RandomSelectorFeature)Feature.RANDOM_SELECTOR;
    }

    public static class Key
    extends ConfiguredFeatureKey<AsRandomSelect> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public AsRandomSelect bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new AsRandomSelectImpl(ctx, this.key);
        }
    }
}

