/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.RandomSelectorFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureManager;
import org.betterx.wover.feature.api.configured.configurators.AsMultiPlaceRandomSelect;
import org.betterx.wover.feature.api.placed.FeaturePlacementBuilder;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.betterx.wover.util.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsMultiPlaceRandomSelectImpl
extends FeatureConfiguratorImpl<RandomFeatureConfiguration, RandomSelectorFeature>
implements AsMultiPlaceRandomSelect {
    private final List<Triple<BlockStateProvider, Float, Integer>> features = new LinkedList<Triple<BlockStateProvider, Float, Integer>>();
    private AsMultiPlaceRandomSelect.Placer modFunction;
    private static int lastID = 0;

    AsMultiPlaceRandomSelectImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public AsMultiPlaceRandomSelect addAllStates(Block block, int weight) {
        return this.addAllStates(block, weight, lastID + 1);
    }

    @Override
    public AsMultiPlaceRandomSelect addAll(int weight, Block ... blockSet) {
        return this.addAll(weight, lastID + 1, blockSet);
    }

    @Override
    public AsMultiPlaceRandomSelect addAllStatesFor(IntegerProperty prop, Block block, int weight) {
        return this.addAllStatesFor(prop, block, weight, lastID + 1);
    }

    @Override
    public AsMultiPlaceRandomSelect add(Block block, float weight) {
        return this.add((BlockStateProvider)BlockStateProvider.simple((Block)block), weight);
    }

    @Override
    public AsMultiPlaceRandomSelect add(BlockState state, float weight) {
        return this.add((BlockStateProvider)BlockStateProvider.simple((BlockState)state), weight);
    }

    @Override
    public AsMultiPlaceRandomSelect add(BlockStateProvider provider, float weight) {
        return this.add(provider, weight, lastID + 1);
    }

    @Override
    public AsMultiPlaceRandomSelect addAllStates(Block block, int weight, int id) {
        Set states = BlockHelper.getPossibleStates((Block)block);
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        states.forEach(s -> builder.add((Object)block.defaultBlockState(), 1));
        this.add((BlockStateProvider)new WeightedStateProvider(builder.build()), (float)weight, id);
        return this;
    }

    @Override
    public AsMultiPlaceRandomSelect addAll(int weight, int id, Block ... blocks) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (Block block : blocks) {
            builder.add((Object)block.defaultBlockState(), 1);
        }
        this.add((BlockStateProvider)new WeightedStateProvider(builder.build()), (float)weight, id);
        return this;
    }

    @Override
    public AsMultiPlaceRandomSelect addAllStatesFor(IntegerProperty prop, Block block, int weight, int id) {
        Collection values = prop.getPossibleValues();
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        values.forEach(s -> builder.add((Object)((BlockState)block.defaultBlockState().setValue((Property)prop, (Comparable)s)), 1));
        this.add((BlockStateProvider)new WeightedStateProvider(builder.build()), (float)weight, id);
        return this;
    }

    @Override
    public AsMultiPlaceRandomSelect add(Block block, float weight, int id) {
        return this.add((BlockStateProvider)BlockStateProvider.simple((Block)block), weight, id);
    }

    @Override
    public AsMultiPlaceRandomSelect add(BlockState state, float weight, int id) {
        return this.add((BlockStateProvider)BlockStateProvider.simple((BlockState)state), weight, id);
    }

    @Override
    public AsMultiPlaceRandomSelect add(BlockStateProvider provider, float weight, int id) {
        this.features.add((Triple<BlockStateProvider, Float, Integer>)new Triple((Object)provider, (Object)Float.valueOf(weight), (Object)id));
        lastID = Math.max(lastID, id);
        return this;
    }

    @Override
    public AsMultiPlaceRandomSelect placement(AsMultiPlaceRandomSelect.Placer placer) {
        this.modFunction = placer;
        return this;
    }

    private Holder<PlacedFeature> place(BlockStateProvider p, int id) {
        FeaturePlacementBuilder builder = ConfiguredFeatureManager.INLINE_BUILDER.simple().block(p).inlinePlace();
        return this.modFunction.place(builder, id);
    }

    @Override
    @NotNull
    public RandomFeatureConfiguration createConfiguration() {
        if (this.modFunction == null) {
            this.throwStateError("AsMultiPlaceRandomSelect needs a placement.modification Function");
        }
        float sum = this.features.stream().map(p -> (Float)p.second).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        List<WeightedPlacedFeature> features = this.features.stream().map(p -> new WeightedPlacedFeature(this.place((BlockStateProvider)p.first, (Integer)p.third), ((Float)p.second).floatValue() / sum)).toList();
        return new RandomFeatureConfiguration(features.subList(0, features.size() - 1), features.get((int)(features.size() - 1)).feature);
    }

    @Override
    @NotNull
    protected RandomSelectorFeature getFeature() {
        return (RandomSelectorFeature)Feature.RANDOM_SELECTOR;
    }

    public static class Key
    extends ConfiguredFeatureKey<AsMultiPlaceRandomSelect> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public AsMultiPlaceRandomSelect bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new AsMultiPlaceRandomSelectImpl(ctx, this.key);
        }
    }
}

