/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.wover.entrypoint.LibWoverFeature;
import org.betterx.wover.feature.api.features.ConditionFeature;
import org.betterx.wover.feature.api.features.MarkPostProcessingFeature;
import org.betterx.wover.feature.api.features.PillarFeature;
import org.betterx.wover.feature.api.features.PlaceBlockFeature;
import org.betterx.wover.feature.api.features.SequenceFeature;
import org.betterx.wover.feature.api.features.TemplateFeature;
import org.betterx.wover.feature.api.features.config.ConditionFeatureConfig;
import org.betterx.wover.feature.api.features.config.PillarFeatureConfig;
import org.betterx.wover.feature.api.features.config.PlaceFacingBlockConfig;
import org.betterx.wover.feature.api.features.config.SequenceFeatureConfig;
import org.betterx.wover.feature.api.features.config.TemplateFeatureConfig;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class FeatureManagerImpl {
    public static final Feature<PlaceFacingBlockConfig> PLACE_BLOCK = FeatureManagerImpl.registerWithLegacy(LibWoverFeature.C.id("place_block"), PlaceBlockFeature::new, PlaceFacingBlockConfig.CODEC);
    public static final Feature<NoneFeatureConfiguration> MARK_POSTPROCESSING = FeatureManagerImpl.registerWithLegacy(LibWoverFeature.C.id("mark_postprocessing"), codec -> new MarkPostProcessingFeature(), null);
    public static final Feature<SequenceFeatureConfig> SEQUENCE = FeatureManagerImpl.registerWithLegacy(LibWoverFeature.C.id("sequence"), codec -> new SequenceFeature(), null);
    public static final Feature<ConditionFeatureConfig> CONDITION = FeatureManagerImpl.registerWithLegacy(LibWoverFeature.C.id("condition"), codec -> new ConditionFeature(), null);
    public static final Feature<PillarFeatureConfig> PILLAR = FeatureManagerImpl.registerWithLegacy(LibWoverFeature.C.id("pillar"), codec -> new PillarFeature(), null);
    public static final Feature<TemplateFeatureConfig> TEMPLATE = FeatureManagerImpl.registerWithLegacy(LibWoverFeature.C.id("template"), TemplateFeature::new, TemplateFeatureConfig.CODEC);

    public static <C extends FeatureConfiguration, F extends Feature<C>> F register(@NotNull ResourceLocation id, @NotNull F feature) {
        return FeatureManagerImpl.register(FeatureManagerImpl.createKey(id), feature);
    }

    public static <C extends FeatureConfiguration, F extends Feature<C>> F register(@NotNull ResourceKey<Feature<?>> key, @NotNull F feature) {
        Registry.register((Registry)BuiltInRegistries.FEATURE, key, feature);
        return feature;
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> F registerWithLegacy(@NotNull ResourceLocation id, @NotNull Function<Codec<C>, F> feature, Codec<C> codec) {
        ResourceKey<Feature<?>> key = FeatureManagerImpl.createKey(id);
        Feature res = FeatureManagerImpl.register(key, (Feature)feature.apply(codec));
        if (LegacyHelper.isLegacyEnabled()) {
            FeatureManagerImpl.register(LegacyHelper.BCLIB_CORE.convertNamespace(key.location()), (Feature)feature.apply(codec));
        }
        return (F)res;
    }

    @NotNull
    public static ResourceKey<Feature<?>> createKey(ResourceLocation location) {
        return ResourceKey.create((ResourceKey)BuiltInRegistries.FEATURE.key(), (ResourceLocation)location);
    }

    @ApiStatus.Internal
    public static void ensureStaticInitialization() {
    }
}

