/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsNextTo
extends PlacementFilter {
    public static final MapCodec<IsNextTo> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPredicate.CODEC.fieldOf("predicate").forGetter(cfg -> cfg.predicate), (App)Vec3i.CODEC.optionalFieldOf("offset", (Object)Vec3i.ZERO).forGetter(cfg -> cfg.offset)).apply((Applicative)instance, IsNextTo::new));
    private final BlockPredicate predicate;
    private final Vec3i offset;

    private IsNextTo(@NotNull BlockPredicate predicate, @NotNull Vec3i offset) {
        this.predicate = predicate;
        this.offset = offset;
    }

    public static PlacementFilter simple(@NotNull BlockPredicate predicate) {
        return new IsNextTo(predicate, Vec3i.ZERO);
    }

    public static PlacementFilter offset(@NotNull BlockPredicate predicate, @Nullable Vec3i offset) {
        return new IsNextTo(predicate, offset);
    }

    protected boolean shouldPlace(PlacementContext ctx, RandomSource random, BlockPos pos) {
        WorldGenLevel level = ctx.getLevel();
        return this.predicate.test((Object)level, (Object)(pos = pos.offset(this.offset)).west()) || this.predicate.test((Object)level, (Object)pos.east()) || this.predicate.test((Object)level, (Object)pos.north()) || this.predicate.test((Object)level, (Object)pos.south());
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return PlacementModifiersImpl.IS_NEXT_TO;
    }
}

